;========================================================================================
;  scsi16.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;
;	scsi16in.r / scsi16ex.r
;		SCSIINROM 16SCSIEXROM 16
;
;	ŏIXV
;		2025-08-03
;
;	
;		has060 -i include -o scsi16in.o -w scsi16.s -SSCSIEXROM=0
;		lk -b fc0000 -o scsi16in.x -x scsi16in.o
;		cv /rn scsi16in.x scsi16in.r
;		has060 -i include -o scsi16ex.o -w scsi16.s -SSCSIEXROM=1
;		lk -b ea0000 -o scsi16ex.x -x scsi16ex.o
;		cv /rn scsi16ex.x scsi16ex.r
;
;	Cӏ
;		ڑĂ邾ŋNłȂȂ@킪
;			NRequest SenseInquirỹAP[VZ
;			ZAP[Vɏ]Ȃ@킪ڑĂƋNɌł܂
;			AP[V\Ȓɂ
;		݂Ɏs\
;			DMA]݂̏ŃoXG[畜AƂDMACSPC̎cf[^HႤꍇ
;			H܂ܕAƓf[^2o͂Ŝ̐ȂȂ
;			oXG[畜AƂSPC̎cf[^pDMAC̃AhXƎcf[^ČvZ
;		ǂݏoɎs\
;			f[^CtF[YXe[^XtF[YɈڂƂACKlQ[ĝ҂Ȃ@킪炵
;			FIFOɂȂOɃtF[YςService RequiredĈُI
;			FIFOłȂƂService Required𖳎
;		SASI HDڑSASItOZbgƋNłȂȂ
;			_B_DSKINId5/a2j󂵂Ă
;			SCSIfoCXhCogݍ݃[`_B_DSKINIׂa2gĂăX^bNj󂳂
;			_B_DSKINId5/a2ی삷
;
;	ǉ@\
;		MC68040MC68060ɑΉ
;			MC68040܂MC68060̂ƂDMA]JnOɃLbVvbV
;			MC68060̖ߗO̔邽MOVEP߂gȂ
;		ubN2048̋@̃fBXNIPLƃfoCXhCoǂݏo
;			fBXNIPL̈ʒu$0400$0800̂ǂł悢
;			S_READȂǂd5̃ubNw4ȏ̂Ƃ3ƌȂ
;			NetBSD/x68k̃CXg[CD-ROMNł
;			fBXNIPLƃfoCXhCoΉȂ΃ubN2048̋@킩NłȂƂɕς͂Ȃ
;			4096ȏ͔Ή
;
;----------------------------------------------------------------

	.include	bioswork.equ
	.include	control2.mac
	.include	dmac.equ
	.include	dosconst.equ
	.include	hdc.equ
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	scsicall.mac
	.include	spc.equ
	.include	sram.equ
	.include	sysport.equ
	.include	vector.equ

  .ifndef SCSI_BIOS_LEVEL
SCSI_BIOS_LEVEL	equ	16		;xB0=SUPER,3=XVI,4=FORMAT.X,10=X68030,16=XEiJ
  .endif
  .ifndef SCSIEXROM
SCSIEXROM	equ	0		;gB0=SCSIINROM,1=SCSIEXROM
  .endif

  .if 16<=SCSI_BIOS_LEVEL
    .if SCSIEXROM
SCSI_BIOS_TITLE	reg	'SCSIEXROM 16 (2025-08-03)'
    .else
SCSI_BIOS_TITLE	reg	'SCSIINROM 16 (2025-08-03)'
    .endif
  .endif

	.cpu	68000
	.text



;--------------------------------------------------------------------------------
;	.include	sc01head.s
;--------------------------------------------------------------------------------

  .if SCSIEXROM
SPC_BASE	equ	SPC_EX_BASE	;gSPCx[XAhX
  .else
SPC_BASE	equ	SPC_IN_BASE	;SPCx[XAhX
  .endif

  .if SCSI_BIOS_LEVEL<=3
abs	reg	.l			;(xxx)abs΃Oɂ
  .else
abs	reg	.w			;(xxx)abs΃[hɂ
  .endif

dLEN	reg	d3			;f[^̒
dID	reg	d4			;(LUN<<16)|SCSI-ID
aBUF	reg	a1			;obt@̃AhX
aSPC	reg	a6			;SPC_xxx(aSPC)SPC̃WX^QƂ

scsi_bios_start:

  .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
    .if SCSIEXROM
;----------------------------------------------------------------
;SPC
spc_ex_base:
	.dcb.b	32,$FF
    .endif
  .endif

  .if SCSI_BIOS_LEVEL<>4
;----------------------------------------------------------------
;ROMNnh
rom_boot_handle:
	.dc.l	rom_boot_routine				;+0
    .if SCSI_BIOS_LEVEL<>10
	.dc.l	rom_boot_routine				;+4
	.dc.l	rom_boot_routine				;+8
	.dc.l	rom_boot_routine				;+12
	.dc.l	rom_boot_routine				;+16
	.dc.l	rom_boot_routine				;+20
	.dc.l	rom_boot_routine				;+24
	.dc.l	rom_boot_routine				;+28
    .endif

;----------------------------------------------------------------
;ROMNnh+32 SCSInh
scsi_init_handle:
	.dc.l	scsi_init_routine				;+32
  .endif

  .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
;----------------------------------------------------------------
;ROMNnh+36 SCSIIN/SCSIEX}WbN
scsi_rom_magic:
    .if SCSIEXROM
	.dc.b	'SCSIEX'					;+36
    .else
	.dc.b	'SCSIIN'					;+36
    .endif
  .endif



;--------------------------------------------------------------------------------
;	.include	sc02boot.s
;--------------------------------------------------------------------------------

  .if SCSI_BIOS_LEVEL<>4
;----------------------------------------------------------------
;ROMNnh+42 SCSI BIOSx
scsi_bios_level:
	.dc.w	SCSI_BIOS_LEVEL					;+42

    .if 16<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
scsi_bios_title:
	.dc.b	SCSI_BIOS_TITLE,0
	.even
    .endif
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;SPCx[Xnh
;	x4SPCx[Xnh̓foCXhCoƊgI
spc_base_handle:
	.dc.l	SPC_BASE		;SPCx[XAhX
  .endif

  .if SCSI_BIOS_LEVEL<>4
;----------------------------------------------------------------
;SCSI[`
;?d0-d1/a1
scsi_init_routine:
    .if SCSI_BIOS_LEVEL<>10
;_SCSIDRVo^
	moveq.l	#_B_INTVCS,d0
	move.l	#$100+_SCSIDRV,d1
	lea.l	iocs_F5_SCSIDRV(pc),a1	;IOCSR[$F5 _SCSIDRV
	trap	#15
      .if SCSI_BIOS_LEVEL<=10
	if	<cmp.l a1,d0>,ne	;
      .else
        .if SCSIEXROM
	ifor	<cmp.l a1,d0>,ne,<btst.b #1,BIOS_SCSI_INITIALIZED.w>,eq
        .else
	ifor	<cmp.l a1,d0>,ne,<btst.b #0,BIOS_SCSI_INITIALIZED.w>,eq
        .endif
	;_SCSIDRṼxN^wĂȂ܂SCSIς݃tOZbgĂȂƂ
      .endif
	;_S_RESETĂяo
		moveq.l	#_SCSIDRV,d0
		moveq.l	#_S_RESET,d1
		trap	#15
      .if 16<=SCSI_BIOS_LEVEL
		goto	<tst.b SRAM_SCSI_SASI_FLAG>,eq,scsi_init_skip	;SASI@킪ڑĂȂ
		goto	<tst.l BIOS_SCSI_OLD_VERIFY.w>,ne,scsi_init_skip	;ɊgĂ
      .endif
	;IOCSR[$40`$4Fo^
		bsr	install_sasi_iocs	;SCSIoXɐڑĂSASI@IOCSR[$40`$4Főł悤ɂ
	;TRAP#11(BREAK)o^
		moveq.l	#_B_INTVCS,d0
		moveq.l	#OFFSET_TRAP_11/4,d1	;OxN^$2B TRAP#11(BREAK)
		lea.l	trap_11_break(pc),a1	;TRAP#11(BREAK)
		trap	#15
      .if 16<=SCSI_BIOS_LEVEL
	;TRAP#11(BREAK)o^Ă猳̃xN^ۑ܂ł̊ԂBREAKL[\[ł͂Ȃ̂Ŏ菇ƂĂ͐Ȃ
		move.l	d0,BIOS_SCSI_OLD_TRAP11.l	;OxN^$2B TRAP#11(BREAK)̌̃xN^
	scsi_init_skip:
      .endif
	endif
    .else
	bsr	dskini_all		;SASIn[hfBXN
    .endif
	rts

;----------------------------------------------------------------
;ROMN[`-20 ROMN}WbN
;	ROM 1.3NSCSI-ID߂ƂɊmF
rom_boot_magic:
	.dc.l	'SCSI'

;----------------------------------------------------------------
;ROMN[`-16 SCSIfoCXhCogݍ݃nh
;	Human68k 3.02foCXhCogݍނƂɎQƂ
device_installer_handle:
	.dc.l	device_installer	;SCSIfoCXhCogݍ݃[`

;----------------------------------------------------------------
;ROMN[`-12 SCSIfoCXhCogݍ݃[`̃p[^
;	Human68k 3.02SCSIfoCXhCogݍނƂɎQƂ
;	FORMAT2.Xn[hfBXNɏSCSIfoCXhCo
;	uw肳ꂽSCSI ROMp_S_RESETsAݒ肳ĂȂ_SCSIDRVݒ肷v
;	ƂAQƂĂ
;	ɂIOCSR[$F5 _SCSIDRṼnhȂ΂ȂȂ
device_installer_parameter:
	.dc.l	iocs_F5_SCSIDRV		;IOCSR[$F5 _SCSIDRV

;----------------------------------------------------------------
;ROMN[`-8 foCXhCoʎq
;	Human68k 3.02SCSIfoCXhCogݍނƂɊmF
device_installer_magic:
	.dc.b	'Human68k'

;----------------------------------------------------------------
;ROMN[`
rom_boot_routine:
;NSCSI-ID߂
    .if SCSI_BIOS_LEVEL<>10
	IOCS	_BOOTINF
      .if 3<=SCSI_BIOS_LEVEL
	andi.l	#$00FFFFFF,d0
      .endif
	move.l	d0,d4
	subi.l	#rom_boot_handle,d4	;ROMNnh̃ItZbg
	lsr.l	#2,d4			;NSCSI-ID
    .else
	bsr	get_scsi_id_to_boot	;NSCSI-ID߂
	if	<tst.l d0>,mi
		moveq.l	#0,d0
	endif
	move.l	d0,d4			;NSCSI-ID
    .endif
;<d4.l:NSCSI-IDB-1=SCSINł͂Ȃ
    .if SCSI_BIOS_LEVEL<>10
      .if SCSI_BIOS_LEVEL<=10
;_SCSIDRVo^
	moveq.l	#_B_INTVCS,d0
	move.l	#$100+_SCSIDRV,d1
	lea.l	iocs_F5_SCSIDRV(pc),a1	;IOCSR[$F5 _SCSIDRV
	trap	#15
	if	<cmp.l a1,d0>,ne	;
	;_S_RESETĂяo
		moveq.l	#_SCSIDRV,d0
		moveq.l	#_S_RESET,d1		;SPC̏SCSIoXZbg
		trap	#15
	;(SCSINƂ)
	;IOCSR[$40`$4Fo^
		bsr	install_sasi_iocs	;SCSIoXɐڑĂSASI@IOCSR[$40`$4Főł悤ɂ
	;TRAP#11(BREAK)o^
		moveq.l	#_B_INTVCS,d0
		moveq.l	#OFFSET_TRAP_11/4,d1	;OxN^$2B TRAP#11(BREAK)
		lea.l	trap_11_break(pc),a1	;TRAP#11(BREAK)
		trap	#15
        .if 3<=SCSI_BIOS_LEVEL
		move.l	d0,BIOS_SCSI_OLD_TRAP11.l	;OxN^$2B TRAP#11(BREAK)̌̃xN^
        .endif
	endif
      .else
	bsr	scsi_init_routine	;SCSI[`
      .endif
    .else
	bsr	dskini_all		;SASIn[hfBXN
    .endif
;ANZXJn
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,ne,scsi_boot_failed	;NSCSI-IDSASItOZbgĂ̂Ŏs
    .if SCSI_BIOS_LEVEL<=3
	moveq.l	#10-1,d6		;10܂ŃgC
    .else
	moveq.l	#20-1,d6		;20܂ŃgC
    .endif
scsi_boot_redo:
	bsr	check_confliction_1st	;{̂ƓSCSI-ID̋@킪ȂmF
;<d0.l:-1={̂ƓSCSI-ID̋@͂Ȃ
    .if SCSI_BIOS_LEVEL<=3
	goto	<cmp.l #-1,d0>,ne,scsi_boot_failed	;{̂ƓSCSI-ID̋@킪ڑĂ̂Ŏs
    .else
	addq.l	#1,d0
	goto	ne,scsi_boot_failed	;{̂ƓSCSI-ID̋@킪ڑĂ̂Ŏs
    .endif
;Test Unit Ready
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_TESTUNIT,d1
	trap	#15
    .if SCSI_BIOS_LEVEL<=3
	goto	<cmp.l #0,d0>,eq,test_unit_passed	;_S_TESTUNITCommand CompleteԂ
    .else
	goto	<tst.l d0>,eq,test_unit_passed	;_S_TESTUNITCommand CompleteԂ
    .endif
	goto	<cmp.l #-1,d0>,eq,scsi_boot_retry	;G[̂Ƃ̓gC
	goto	<cmp.l #8,d0>,eq,scsi_boot_retry	;BusŷƂ̓gC
	goto	<cmp.l #2,d0>,ne,scsi_boot_failed	;Check ConditionłȂΎs
;_S_TESTUNITCheck ConditionԂ
;Request Sense
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_REQUEST,d1
    .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;Request SensẽAP[VȂ
;	Request SensẽZXf[^̓G[NXɂ4oCg܂8oCgȏゾAP[V3oCgɂȂĂ
;	NɃAP[Ṽf[^ԂƂSCSI@킪ڑēdĂƃnOAbv
;	Ql: d]y111 FDS120T.DOC
	moveq.l	#3,d3			;AP[V
;+++++ BUG +++++
    .else
	moveq.l	#8,d3			;AP[VB8ȏ
    .endif
    .if SCSI_BIOS_LEVEL<=3
	lea.l	$00002000.l,a1
    .else
	lea.l	$2000.w,a1
    .endif
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed
    .if SCSI_BIOS_LEVEL<=3
	lea.l	$00002000.l,a1
    .else
	lea.l	$2000.w,a1
    .endif
	move.b	(a1),d0			;ZXG[R[h
	andi.b	#$70,d0
	goto	<cmpi.b #$70,d0>,ne,scsi_boot_failed	;gZXL[ȂΎs
	move.b	2(a1),d0		;ZXL[
	goto	eq,scsi_boot_redo	;No Sense̓gC
	goto	<cmp.b #1,d0>,eq,scsi_boot_redo	;Recovered Error̓gC
	goto	<cmp.b #6,d0>,eq,scsi_boot_redo	;Unit Attention̓gC
    .if 10<=SCSI_BIOS_LEVEL
	goto	<cmp.b #2,d0>,eq,scsi_boot_redo	;Not Ready̓gC
    .endif
	goto	scsi_boot_failed	;ȊO͎s

;gC
scsi_boot_retry:
	dbra.w	d6,scsi_boot_redo_1
;gC񐔂𒴂
	goto	scsi_boot_failed

scsi_boot_redo_1:
	goto	scsi_boot_redo

scsi_boot_failed:
	rts

;_S_TESTUNITCommand CompleteԂ
test_unit_passed:
    .if SCSI_BIOS_LEVEL<=3
	bsr	check_confliction_1st	;{̂ƓSCSI-ID̋@킪ȂmF
    .else
	bsr	check_confliction_2nd	;{̂ƓSCSI-ID̋@킪ȂmF(mFς݂ȂΉȂ)
    .endif
;<d0.l:-1={̂ƓSCSI-ID̋@͂Ȃ
    .if SCSI_BIOS_LEVEL<=3
	goto	<cmp.l #-1,d0>,ne,scsi_boot_failed	;{̂ƓSCSI-ID̋@킪ڑĂ̂Ŏs
    .else
	addq.l	#1,d0
	goto	ne,scsi_boot_failed	;{̂ƓSCSI-ID̋@킪ڑĂ̂Ŏs
    .endif
;Inquiry
    .if SCSI_BIOS_LEVEL<=3
	lea.l	$00002000.l,a1
    .else
	lea.l	$2000.w,a1
    .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_INQUIRY,d1
    .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;InquirỹAP[VȂ
;	InquiryEVPD0̂ƂAP[V5oCgȏłȂ΂ȂȂ̂1oCgɂȂĂ
;	Inquiry1ڂ5oCgv2ڂɒǉf[^+5oCgv̂
;	ŏ36oCgvĂǂ2ɕ
	moveq.l	#1,d3
;+++++ BUG +++++
    .else
	moveq.l	#5,d3			;AP[VB5ȏ
    .endif
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed	;INQUIRYŎs
    .if SCSI_BIOS_LEVEL<=3
	gotoand	<cmpi.b #$84,0.w(a1)>,ne,<tst.b 0.w(a1)>,ne,scsi_boot_failed	;SHARP MOƃ_CNgANZXfoCXȊO͎s
    .else
	ifand	<btst.b #SRAM_SCSI_IGNORE_BIT,SRAM_SCSI_MODE>,eq,<tst.b (a1)>,ne,<cmpi.b #$04,(a1)>,ne,<cmpi.b #$05,(a1)>,ne,<cmpi.b #$07,(a1)>,ne,<cmpi.b #$84,(a1)>,ne
		;^Cvł͂Ȃ
		;foCX^Cv
		;	$00(_CNgANZXfoCX)
		;	$04(CgXfoCX(ǋL^fBXN))
		;	$05(CD-ROMfoCX)
		;	$07(foCX(\fBXN))
		;	$84(SHARP MO)
		;ł͂Ȃ
		goto	scsi_boot_failed	;s

	endif
    .endif
;Rezero Unit
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_REZEROUNIT,d1
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed	;REZEROUNITŎs
;Read Capacity
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READCAP,d1
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed	;READCAPŎs
    .if SCSI_BIOS_LEVEL<=0
;+++++ BUG +++++
;ubN2048ȏ̂Ƃfʂ肳Ă邪ɓ삵Ȃ
;+++++ BUG +++++
    .elif SCSI_BIOS_LEVEL<=3
	goto	<cmpi.l #2048,4(a1)>,cc,scsi_boot_failed	;ubN2048ȏ̂Ƃ͎s
    .elif SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;ubN2048ȏ̂Ƃfʂ肳Ă邪ɓ삵Ȃ
;+++++ BUG +++++
    .endif
	move.l	4(a1),d5		;ubN
	lsr.l	#8,d5
	lsr.l	#1,d5			;2560,5121,10242,20484,40968,c
    .if 16<=SCSI_BIOS_LEVEL
	goto	<cmp.l #4,d5>,hi,scsi_boot_failed	;ubN傫̂Ŏs
	if	eq			;2048
		moveq.l	#3,d5			;20483
	endif
    .endif
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
    .if SCSI_BIOS_LEVEL<=10
;$0000-$03FF$2000-$23FFɓǂݍ
	moveq.l	#$0000/256,d2
      .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
	lsr.l	d5,d2
	moveq.l	#$0400/256,d3
	lsr.l	d5,d3
      .else
	moveq.l	#$0400/256,d3
	bsr	adjust_block_number	;ubNɉăubNԍƃubN𒲐
      .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READ,d1
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed	;READŎs
	gotoor	<cmpi.l #'X68S',0.w(a1)>,ne,<cmpi.l #'CSI1',4(a1)>,ne,scsi_boot_failed	;uĂȂ̂Ŏs
;$0400-$07FF$2000-$23FFɓǂݍ
	moveq.l	#$0400/256,d2
      .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
	lsr.l	d5,d2
	moveq.l	#$0400/256,d3
	lsr.l	d5,d3
      .else
	moveq.l	#$0400/256,d3
	bsr	adjust_block_number	;ubNɉăubNԍƃubN𒲐
      .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READ,d1
	trap	#15
	goto	<tst.l d0>,ne,scsi_boot_failed	;READŎs
	goto	<cmpi.b #$60,(a1)>,ne,scsi_boot_failed	;IPL̐擪brałȂ̂Ŏs
	jsr	(a1)			;fBXNIPLN
	goto	scsi_boot_failed	;fBXNIPLAĂĂ܂̂Ŏs

    .else
;$0000-$07FF$2000-$27FFɓǂݍ
	moveq.l	#$0000/256,d2
	moveq.l	#$0800/256,d3
	lsr.l	d5,d2
	lsr.l	d5,d3
	lea.l	$2000.w,a1
	SCSI	_S_READ
	goto	<tst.l d0>,ne,scsi_boot_failed	;READŎs
	gotoor	<cmpi.l #'X68S',(a1)>,ne,<cmpi.l #'CSI1',4(a1)>,ne,scsi_boot_failed	;uĂȂ̂Ŏs
	if	<cmpi.b #$60,$0400(a1)>,eq	;$0400-$07FFɃfBXNIPL
		;$2400-$27FF$2000-$23FFɃRs[
		lea.l	$2000.w,a1
		move.w	#$0400/4-1,d0
		for	d0
			move.l	$0400(a1),(a1)+
		next
		move.w	#$0400/4-1,d0
		for	d0
			clr.l	(a1)+
		next
	;2025-08-02 d2.l0ɂȂĂNetBSDNȂ
	;	https://github.com/NetBSD/src/blob/fcd96f7d78eb0d70b7f75be4fa69e46d5420b1b1/sys/arch/x68k/stand/boot_ufs/boot.S#L204C5-L204C54
		moveq.l	#$0400/256,d2
		lsr.l	d5,d2
	else
	;$0400-$07FFɃfBXNIPLȂ
	;$0800-$0FFF$2000-$27FFɓǂݍ
		moveq.l	#$0800/256,d2
		moveq.l	#$0800/256,d3
		lsr.l	d5,d2
		lsr.l	d5,d3
		lea.l	$2000.w,a1
		SCSI	_S_READ
		goto	<tst.l d0>,ne,scsi_boot_failed	;READŎs
		goto	<cmpi.b #$60,(a1)>,ne,scsi_boot_failed	;$0800-$0FFFɃfBXNIPLȂ
	;$0800-$0FFFɃfBXNIPL
	endif
	bsr	cache_flush
	moveq.l	#0,d0
	lea.l	$2000.w,a1
	jsr	(a1)			;fBXNIPLN
	goto	scsi_boot_failed	;fBXNIPLAĂĂ܂̂Ŏs

    .endif

    .if SCSI_BIOS_LEVEL==10
;----------------------------------------------------------------
;NSCSI-ID߂
;>d0.l:SCSI-ID(0`7,-1=SCSINł͂Ȃ)
get_scsi_id_to_boot:
	IOCS	_BOOTINF
	andi.l	#$00FFFFFF,d0
	if	<cmp.l #$00000100,d0>,cc	;ROMN܂SRAMN
	;+++++ BUG +++++
	;ROMNAhX-20spӂɃ[hĂ
	;	SRAMNȂSRAMN[`̐擪4oCg̒l-20[h邱ƂɂȂ
	;	NSCSI ROMłȂĂSCSI-ID𔻕ʂł悤ɂ悤Ƃ悤Ɍ邪ړIs
		movea.l	d0,a0			;ROMNnh܂SRAMNAhX
		movea.l	(a0),a0			;ROMNAhX
	;+++++ BUG +++++
		if	<cmpi.l #'SCSI',rom_boot_magic-rom_boot_routine(a0)>,eq	;ROMN}WbNrBSCSIN
			andi.l	#31,d0			;SCSI ROM̐擪̃ItZbg
			lsr.l	#2,d0			;NSCSI-ID
			rts

		endif
	;SCSINł͂Ȃ
	endif
;ROMN܂SRAMNł͂Ȃ
	moveq.l	#-1,d0
	rts
    .endif

    .if 10<=SCSI_BIOS_LEVEL
;NłȂ
next_device:
	bset.b	d2,BIOS_SCSI_UNBOOTABLE.w
	addq.w	#1,d2
	goto	install_device
    .endif

;----------------------------------------------------------------
;SCSIfoCXhCogݍ݃[`
;	Human68kSCSIfoCXhCogݍނƂŏɌĂяo
;<d2.l:(p[eBV̐<<16)|gݍSCSI-IDB0BgݍSCSI-ID8̂ƂI
;<a1.l:foCXhCõRs[̃AhX
;>d2.l:(p[eBV̐<<16)|gݍSCSI-ID
device_installer:
	push	d0-d1/d3-d7/a0-a6
;NSCSI-ID߂
    .if SCSI_BIOS_LEVEL<>10
	IOCS	_BOOTINF
      .if 3<=SCSI_BIOS_LEVEL
	andi.l	#$00FFFFFF,d0
      .endif
	subi.l	#rom_boot_handle,d0	;ROMNnh̃ItZbg
	if	cc
		lsr.l	#2,d0			;NSCSI-ID
		move.b	d0,d7			;NSCSI-ID
		goto	<cmpi.l #8,d0>,cs,install_device	;SCSIN
	endif
	moveq.l	#-1,d7
	goto	<cmpi.l #8,d0>,eq,install_device	;NSCSI-ID8BSASINH
	goto	<tst.b d2>,ne,install_device	;gݍSCSI-ID0ł͂Ȃ
;gݍSCSI-ID0
	movea.l	a1,a2
;<a2.l:foCXhCõRs[̃AhX
      .if SCSI_BIOS_LEVEL<=10
;_SCSIDRVo^
	moveq.l	#_B_INTVCS,d0
	move.l	#$100+_SCSIDRV,d1
	lea.l	iocs_F5_SCSIDRV(pc),a1	;IOCSR[$F5 _SCSIDRV
	trap	#15
	if	<cmp.l a1,d0>,ne	;
	;_S_RESETĂяo
		moveq.l	#_SCSIDRV,d0
		moveq.l	#_S_RESET,d1		;SPC̏SCSIoXZbg
		trap	#15
	;(SCSINȂƂ)
	;IOCSR[$40`$4Fo^Ȃ
	;TRAP#11(BREAK)o^
		moveq.l	#_B_INTVCS,d0
		moveq.l	#OFFSET_TRAP_11/4,d1	;OxN^$2B TRAP#11(BREAK)
		lea.l	trap_11_break(pc),a1	;TRAP#11(BREAK)
		trap	#15
        .if 3<=SCSI_BIOS_LEVEL
		move.l	d0,BIOS_SCSI_OLD_TRAP11.l	;OxN^$2B TRAP#11(BREAK)̌̃xN^
        .endif
	endif
      .else
	bsr	scsi_init_routine	;SCSI[`
      .endif
	movea.l	a2,a1
;<a1.l:foCXhCõRs[̃AhX
    .else
	bsr	get_scsi_id_to_boot	;NSCSI-ID߂
	if	<tst.l d0>,pl
		move.b	d0,d7			;NSCSI-ID
		goto	<cmpi.w #8,d0>,cs,install_device
	endif
	moveq.l	#-1,d7			;SCSINł͂Ȃ
    .endif
;SCSIN
;<d2.l:(p[eBV̐<<16)|gݍSCSI-ID
;<d7.l:NSCSI-IDB-1=SCSINł͂Ȃ
;<a1.l:foCXhCõRs[̃AhX
install_device:
	goto	<cmp.w #8,d2>,eq,install_finish	;gݍSCSI-ID8BI
;{̂ƓSCSI-ID̋@킪ȂmF
    .if SCSI_BIOS_LEVEL<=3
	bsr	check_confliction_1st	;{̂ƓSCSI-ID̋@킪ȂmF
	goto	<cmp.l #-1,d0>,ne,install_finish	;{̂ƓSCSI-ID̋@킪
    .else
	bsr	check_confliction_2nd	;{̂ƓSCSI-ID̋@킪ȂmF(mFς݂ȂΉȂ)
	goto	<addq.l #1,d0>,ne,install_finish	;{̂ƓSCSI-ID̋@킪
    .endif
;{̂ƓSCSI-ID̋@͂Ȃ
wait_device:
	moveq.l	#0,d4
	move.w	d2,d4			;gݍSCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,ne,next_device	;SASI͎s
    .if 10<=SCSI_BIOS_LEVEL
	goto	<btst.b d4,BIOS_SCSI_UNBOOTABLE.w>,ne,next_device	;NłȂ
    .endif
	move.b	SRAM_SCSI_MODE,d0	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
	andi.b	#7,d0			;{̂SCSI-ID
	goto	<cmp.b d4,d0>,eq,next_device	;{͎̂s
;Test Unit Ready
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_TESTUNIT,d1
	trap	#15
	if	<cmp.l #2,d0>,ne	;Check ConditionȊO
		goto	<cmp.l #8,d0>,eq,wait_device	;Busy͑҂
		goto	<tst.l d0>,ne,next_device	;Check ConditionBusyȊÕG[͎s
	endif
;Request Sense
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_REQUEST,d1
    .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;Request SensẽAP[VȂ
;	
	moveq.l	#3,d3
;+++++ BUG +++++
    .else
	moveq.l	#8,d3			;AP[VB8ȏ
    .endif
	trap	#15
	goto	<tst.l d0>,ne,next_device	;REQUESTŎs
;Inquiry
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_INQUIRY,d1
	moveq.l	#36,d3
	trap	#15
    .if SCSI_BIOS_LEVEL<>10
	goto	<tst.l d0>,ne,next_device	;INQUIRYŎs
    .else
	tst.l	d0
;!!! V[gœ͂̂Ƀ[hɂȂĂ
	bne.w	next_device		;INQUIRYŎs
    .endif
    .if SCSI_BIOS_LEVEL<=3
	gotoand	<cmpi.b #$84,0.w(a1)>,ne,<tst.b 0.w(a1)>,ne,next_device	;SHARP MOƃ_CNgANZXfoCXȊO͎s
    .else
	ifand	<btst.b #6,SRAM_SCSI_MODE>,eq,<tst.b (a1)>,ne,<cmpi.b #$04,(a1)>,ne,<cmpi.b #$05,(a1)>,ne,<cmpi.b #$07,(a1)>,ne,<cmpi.b #$84,(a1)>,ne
	;^Cvł͂Ȃ
	;foCX^Cv
	;	$00(_CNgANZXfoCX)
	;	$04(CgXfoCX(ǋL^fBXN))
	;	$05(CD-ROMfoCX)
	;	$07(foCX(\fBXN))
	;	$84(SHARP MO)
	;ł͂Ȃ
		goto	next_device		;s

	endif
    .endif
;Read Capacity
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READCAP,d1
	trap	#15
	goto	<tst.l d0>,ne,next_device	;READCAPŎs
	move.l	d2,d6			;(p[eBV̐<<16)|gݍSCSI-ID
	move.l	4(a1),d5		;ubN
	lsr.l	#8,d5
	lsr.l	#1,d5			;2560,5121,10242,20484,40968,c
    .if 16<=SCSI_BIOS_LEVEL
	goto	<cmp.l #4,d5>,hi,next_device	;ubN傫̂Ŏs
	if	eq			;2048
		moveq.l	#3,d5			;20483
	endif
    .endif
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
    .if SCSI_BIOS_LEVEL<=10
;$0800-$0BFFa1-(a1+$03FF)ɓǂݍ
	moveq.l	#$0800/256,d2
      .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
	lsr.l	d5,d2
	moveq.l	#$0400/256,d3
	lsr.l	d5,d3
      .else
	moveq.l	#$0400/256,d3
	bsr	adjust_block_number	;ubNɉăubNԍƃubN𒲐
      .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READ,d1
	trap	#15
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
	goto	<cmpi.l #'X68K',(a1)>,ne,next_device	;p[eBVe[uȂBuĂȂ
;SCSIN̂Ƃ͋NSCSI-ID̎Ñp[eBV܂ł̎N܂͎gp\ȃp[eBV̐𐔂
;SCSINłȂƂׂ͂ĂSCSI-ID̎N܂͎gp\ȃp[eBV̐𐔂
	swap.w	d2			;(gݍSCSI-ID<<16)|p[eBV̐
	if	<cmp.b d7,d4>,ls	;(݂SCSI-ID)-(NSCSI-ID)
	;SCSIN̂Ƃ͑gݍSCSI-IDNSCSI-IDȉBSCSINłȂƂׂ͂
      .if SCSI_BIOS_LEVEL<=3
		if	ne			;gݍSCSI-IDNSCSI-IDƈႤ
			bsr	count_partition_1	;N܂͎gp\ȃp[eBV̐𐔂
			add.w	d3,d2			;p[eBV̐Z
		else				;gݍSCSI-IDNSCSI-IDƓ
			bsr	count_partition_2	;N܂͎gp\ȃp[eBV̐Ñp[eBV܂Ő
			add.w	d3,d2			;p[eBV̐Z
		endif
      .else
		bsr	count_partition		;N܂͋N\ȃp[eBV𐔂
		add.w	d3,d2			;p[eBV̐Z
      .endif
	endif
	swap.w	d2			;(p[eBV̐<<16)|gݍSCSI-ID
	move.l	d2,d6			;(p[eBV̐<<16)|gݍSCSI-ID
;$0000-$03FF(a1)-(a1+$03FF)ɓǂݍ
	moveq.l	#$0000/256,d2
      .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
	lsr.l	d5,d2
	moveq.l	#$0400/256,d3
	lsr.l	d5,d3
      .else
	moveq.l	#$0400/256,d3
	bsr	adjust_block_number	;ubNɉăubNԍƃubN𒲐
      .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READ,d1
	trap	#15
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
	gotoor	<cmpi.l #'X68S',0.w(a1)>,ne,<cmpi.l #'CSI1',4(a1)>,ne,next_device	;uĂȂ
;$0C00-$3FFF(a1)-(a1+$33FF)ɓǂݍ
	moveq.l	#$0C00/256,d2
      .if (SCSI_BIOS_LEVEL<=3)|(16<=SCSI_BIOS_LEVEL)
	lsr.l	d5,d2
	moveq.l	#$3400/256,d3
	lsr.l	d5,d3
      .else
	moveq.l	#$3400/256,d3
	bsr	adjust_block_number	;ubNɉăubNԍƃubN𒲐
      .endif
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_READ,d1
	trap	#15
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
    .else
;<d6.l:(p[eBV̐<<16)|gݍSCSI-ID
	movea.l	a1,a2
;<a2.l:foCXhCõRs[̃AhX
;$0000-$07FF(a2)-(a2+$07FF)ɓǂݍ
	moveq.l	#$0000/256,d2
	moveq.l	#$0800/256,d3
	lsr.l	d5,d2
	lsr.l	d5,d3
	movea.l	a2,a1
	SCSI	_S_READ
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
	gotoor	<cmpi.l #'X68S',0.w(a1)>,ne,<cmpi.l #'CSI1',4(a1)>,ne,next_device	;uĂȂ
;$0800-$0FFF(a2)-(a2+$07FF)ɓǂݍ
	moveq.l	#$0800/256,d2
	moveq.l	#$0800/256,d3
	lsr.l	d5,d2
	lsr.l	d5,d3
	movea.l	a2,a1
	SCSI	_S_READ
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
	goto	<cmpi.l #'X68K',(a1)>,ne,next_device	;p[eBVe[uȂBuĂȂ
;SCSIN̂Ƃ͋NSCSI-ID̎Ñp[eBV܂ł̎N܂͎gp\ȃp[eBV̐𐔂
;SCSINłȂƂׂ͂ĂSCSI-ID̎N܂͎gp\ȃp[eBV̐𐔂
	swap.w	d2			;(gݍSCSI-ID<<16)|p[eBV̐
	if	<cmp.b d7,d4>,ls	;(݂SCSI-ID)-(NSCSI-ID)
	;SCSIN̂Ƃ͑gݍSCSI-IDNSCSI-IDȉBSCSINłȂƂׂ͂
		bsr	count_partition		;N܂͋N\ȃp[eBV𐔂
		add.w	d3,d2			;p[eBV̐Z
	endif
	swap.w	d2			;(p[eBV̐<<16)|gݍSCSI-ID
	move.l	d2,d6			;(p[eBV̐<<16)|gݍSCSI-ID
;(a2+$0400)-(a2+$07FF)(a2)-(a2+$03FF)ɃRs[
	movea.l	a2,a1
	move.w	#$0400/4-1,d0
	for	d0
		move.l	$0400(a1),(a1)+
	next
;$1000-$3FFF(a2+$0400)-(a2+$33FF)ɓǂݍ
	moveq.l	#$1000/256,d2
	moveq.l	#$3000/256,d3
	lsr.l	d5,d2
	lsr.l	d5,d3
	lea.l	$0400(a2),a1
	SCSI	_S_READ
	move.l	d6,d2			;(p[eBV̐<<16)|gݍSCSI-ID
	goto	<tst.l d0>,ne,next_device	;READŎs
	movea.l	a2,a1
    .endif
;foCXwb_P[g
	do
		gotoor	<cmpi.l #($01.shl.24)|'SCH',14(a1)>,ne,<cmpi.l #'DISK',18(a1)>,ne,next_device	;SCSIfoCXhCoȂ
		move.l	a1,d0
		add.l	d0,6(a1)		;XgeWnhP[g
		add.l	d0,10(a1)		;C^vgnhP[g
		move.l	(a1),d0			;lNXgfoCXhConh
		break	<cmp.l #-1,d0>,eq	;Ō̃foCXhCo
		add.l	a1,d0			;lNXgfoCXhConhP[g
		move.l	d0,(a1)
		movea.l	d0,a1
	while	t
	swap.w	d2			;(gݍSCSI-ID<<16)|p[eBV̐
	move.b	d2,22(a1)		;Ō̃foCXhCoɃp[eBV̐ݒ肷
	swap.w	d2			;(p[eBV̐<<16)|gݍSCSI-ID
    .if SCSI_BIOS_LEVEL<=3
	pop_test
	addq.w	#1,d2			;̑gݍSCSI-ID
	rts

;SCSI-ID
next_device:
	addq.w	#1,d2			;̑gݍSCSI-ID
	goto	install_device

install_finish:
	pop
	moveq.l	#-1,d2
	rts
    .else
	bclr.b	d2,BIOS_SCSI_UNBOOTABLE.w	;SCSI-ID͋N\
	addq.w	#1,d2			;̑gݍSCSI-ID
device_installer_end:
	pop
	rts

install_finish:
	moveq.l	#-1,d2
	goto	device_installer_end
    .endif

    .if SCSI_BIOS_LEVEL<=3
;----------------------------------------------------------------
;N܂͎gp\ȃp[eBV𐔂
;<a1.l:p[eBVe[u̐擪
;>d3.w:p[eBV̐
count_partition_1:
	push	d2/a1
	moveq.l	#15-1,d2
	moveq.l	#0,d3
	for	d2
		lea.l	16(a1),a1
		continue	<tst.b (a1)>,eq	;p[eBVȂ
		continue	<cmpi.l #'Huma',(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		continue	<cmpi.l #'n68k',4(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		move.b	8(a1),d0		;0=N,1=gps,2=gp\
		continue	<btst.l #0,d0>,ne	;gps
		addq.w	#1,d3			;N܂͎gp\
	next
	pop
	rts

;----------------------------------------------------------------
;N܂͎gp\ȃp[eBV𐔂
;	Ñp[eBVŏI
;<a1.l:p[eBVe[u̐擪
;>d3.w:p[eBV̐
count_partition_2:
	push	d2/a1
	moveq.l	#15-1,d2
	moveq.l	#0,d3
	for	d2
		lea.l	16(a1),a1
		continue	<tst.b (a1)>,eq	;p[eBVȂ
		continue	<cmpi.l #'Huma',(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		continue	<cmpi.l #'n68k',4(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		move.b	8(a1),d0		;0=N,1=gps,2=gp\
		continue	<btst.l #0,d0>,ne	;gps
		addq.w	#1,d3			;N܂͎gp\
		break	<tst.b d0>,eq		;N
	next
	pop
	rts
    .else
;----------------------------------------------------------------
;N܂͎gp\ȃp[eBV𐔂
;	NSCSI-ID̂Ƃ͎Ñp[eBVŏI
;<ccr:(݂SCSI-ID)-(NSCSI-ID)
;<a1.l:p[eBVe[u̐擪
;>d3.w:p[eBV̐
count_partition:
	push	d1/d2/a1
	seq.b	d1			;-1=(݂SCSI-ID)==(NSCSI-ID)
	moveq.l	#15-1,d2
	moveq.l	#0,d3
	for	d2
		lea.l	16(a1),a1
		continue	<tst.b (a1)>,eq	;p[eBVȂ
		continue	<cmpi.l #'Huma',(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		continue	<cmpi.l #'n68k',4(a1)>,ne	;Human68k̃p[eBVł͂Ȃ
		move.b	8(a1),d0		;0=N,1=gps,2=gp\
		continue	<btst.l #0,d0>,ne	;gps
		addq.w	#1,d3			;N܂͎gp\
		continue	<tst.b d1>,eq	;NSCSI-IDł͂Ȃ
		break	<tst.b d0>,eq		;NSCSI-IDŎN̂ƂI
	next
	pop
	rts
    .endif

    .if 10<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;{̂ƓSCSI-ID̋@킪ȂmF(mFς݂ȂΉȂ)
;>d0.l:{̂ƓSCSI-ID̋@킪ȂB0=,-1=Ȃ
check_confliction_2nd:
	moveq.l	#-1,d0
	goto	<tst.b BIOS_SCSI_NOT_CONFLICT.w>,ne,check_confliction_end
    .endif
;----------------------------------------------------------------
;{̂ƓSCSI-ID̋@킪ȂmF
;>d0.l:{̂ƓSCSI-ID̋@킪ȂB0=,-1=Ȃ
check_confliction_1st:
    .if SCSI_BIOS_LEVEL<=3
	movem.l	d4,-(sp)
    .else
	move.l	d4,-(sp)
	st.b	BIOS_SCSI_NOT_CONFLICT.w
    .endif
	move.b	SRAM_SCSI_MODE,d4	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
	andi.b	#7,d4			;{̂SCSI-ID
	moveq.l	#_SCSIDRV,d0
	moveq.l	#_S_TESTUNIT,d1
	trap	#15
	move.l	(sp)+,d4
check_confliction_end:
	rts

    .if SCSI_BIOS_LEVEL==10
;----------------------------------------------------------------
;ubNɉăubNԍƃubN𒲐
;<d2.l:ubNԍB256oCg/ubN
;<d3.l:ubNB256oCg/ubN
;<d5.w:ubNwB0=256,1=512,2=1024,3=2048
;>d2.l:ubNԍ
;>d3.l:ubN
adjust_block_number:
	if	<cmpi.w #3,d5>,cs
		lsr.l	d5,d2
		lsr.l	d5,d3
		rts

	endif
	lsr.l	#2,d2
	lsr.l	#2,d3
	rts
    .endif
  .endif



;--------------------------------------------------------------------------------
;	.include	sc03break.s
;--------------------------------------------------------------------------------

  .if SCSI_BIOS_LEVEL<>4
;----------------------------------------------------------------
;TRAP#11(BREAK)
;	FDHD֘AIOCSR[($40`$4F,$F5)̏łȂ΃VbsOs
;<d0.b:bit0:0=BREAK(CTRL+C),1=SHIFT+BREAK(CTRL+S)
trap_11_break:
	push	d0-d7/a0-a6
	if	<btst.l #0,d0>,eq	;BREAKBSHIFT+BREAKł͂Ȃ
		move.w	(BIOS_IOCS_NUMBER)abs,d0	;sIOCSR[̔ԍB-1=Ȃ
		goto	<cmp.w #$0040,d0>,cs,do_eject_all
		ifand	<cmp.w #$0050,d0>,cc,<cmp.w #_SCSIDRV,d0>,ne
		do_eject_all:
			bsr	eject_all		;VbsO
		endif
	endif
	pop
    .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;SASIn[hfBXN@SCSI{[htBREAKL[SASIn[hfBXNVbsO@\
;X68000 PRO[HD]̎戵ɁuRs[^{̂̓쒆[BREAK]L[ƂɂACwbh̑ޔƂsƂł܂vƂLq
;+++++ BUG +++++
	rte
    .else
	move.l	BIOS_SCSI_OLD_TRAP11.w,-(sp)	;TRAP#11(BREAK)̌̃xN^
	rts
    .endif
  .endif



;--------------------------------------------------------------------------------
;	.include	sc04eject.s
;--------------------------------------------------------------------------------

  .if SCSI_BIOS_LEVEL<>4
;----------------------------------------------------------------
;VbsO
eject_all:
	move.w	#$8000,d1
	do
		bsr	iocs_4F_B_EJECT		;IOCSR[$4F _B_EJECT
		add.w	#$0100,d1
	while	<cmp.w #$9000,d1>,cs
	rts
  .endif



;--------------------------------------------------------------------------------
;	.include	sc05iocs1.s
;--------------------------------------------------------------------------------

;----------------------------------------------------------------
;IOCSR[$F5 _SCSIDRV
;<d1.l:SCSIR[ԍ
iocs_F5_SCSIDRV:
	push	d1/dLEN/aBUF/a2/aSPC
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.l #$00000010,d1>,cs,scsi_00_0F	;SCSIR[$00`$0F
	goto	<cmp.l #$00000020,d1>,cs,scsi_10_1F	;SCSIR[$10`$1F
	goto	<cmp.l #$00000040,d1>,cs,scsi_20_3F	;SCSIR[$20`$3F
;+++++ BUG +++++
;SCSIR[$40ȏw肷SCSIR[$00`$0F̃Wve[uOĖ\
	goto	<cmp.l #$00000020,d1>,cs,scsi_10_1F
;{
;	goto	<cmp.l #$00000050,d1>,cs,scsi_40_4F	;SCSIR[$40`$4F
;	goto	scsi_10_1F		;SCSIR[$50`
;+++++ BUG +++++
  .else
	moveq.l	#$10,d0
	goto	<cmp.l d0,d1>,cs,scsi_00_0F	;SCSIR[$00`$0F
	add.l	d0,d0
	goto	<cmp.l d0,d1>,cs,scsi_10_1F	;SCSIR[$10`$1F
	add.l	d0,d0
	goto	<cmp.l d0,d1>,cs,scsi_20_3F	;SCSIR[$20`$3F
	moveq.l	#$50,d0
	goto	<cmp.l d0,d1>,cs,scsi_40_4F	;SCSIR[$40`$4F
	goto	scsi_10_1F		;SCSIR[$50`
  .endif

;SCSIR[$00`$0F
scsi_00_0F:
	lea.l	jump_00_0F(pc),a2	;SCSIR[$00`$0F̃Wve[u
	goto	scsi_go

;SCSIR[$20`$3F
scsi_20_3F:
  .if SCSI_BIOS_LEVEL<=4
	sub.l	#$00000020,d1
  .else
	moveq.l	#$20,d0
	sub.l	d0,d1
  .endif
	lea.l	jump_20_3F(pc),a2	;SCSIR[$20`$3F̃Wve[u
	goto	scsi_go

;SCSIR[$40`$4F
scsi_40_4F:
  .if SCSI_BIOS_LEVEL<=4
	sub.l	#$00000040,d1
  .else
	moveq.l	#$40,d0
	sub.l	d0,d1
  .endif
	lea.l	jump_40_4F(pc),a2	;SCSIR[$40`$4F̃Wve[u
scsi_go:
	lsl.l	#2,d1
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_IN_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
	move.l	(a2,d1.w),d1
	adda.l	d1,a2
	jsr	(a2)
	pop_test
	rts

;SCSIR[$10`$1F
;SCSIR[$50`
scsi_10_1F:
	moveq.l	#-1,d0
	pop
	rts

;`SCSIR[
scsi_XX_undefined:
	moveq.l	#-1,d0
	rts

;SCSIR[$00`$0F̃Wve[u
jump_00_0F:
	.dc.l	scsi_00_S_RESET-jump_00_0F	;SCSIR[$00 _S_RESET
	.dc.l	scsi_01_S_SELECT-jump_00_0F	;SCSIR[$01 _S_SELECT
	.dc.l	scsi_02_S_SELECTA-jump_00_0F	;SCSIR[$02 _S_SELECTA
	.dc.l	scsi_03_S_CMDOUT-jump_00_0F	;SCSIR[$03 _S_CMDOUT
	.dc.l	scsi_04_S_DATAIN-jump_00_0F	;SCSIR[$04 _S_DATAIN
	.dc.l	scsi_05_S_DATAOUT-jump_00_0F	;SCSIR[$05 _S_DATAOUT
	.dc.l	scsi_06_S_STSIN-jump_00_0F	;SCSIR[$06 _S_STSIN
	.dc.l	scsi_07_S_MSGIN-jump_00_0F	;SCSIR[$07 _S_MSGIN
	.dc.l	scsi_08_S_MSGOUT-jump_00_0F	;SCSIR[$08 _S_MSGOUT
	.dc.l	scsi_09_S_PHASE-jump_00_0F	;SCSIR[$09 _S_PHASE
	.dc.l	scsi_0A_S_LEVEL-jump_00_0F	;SCSIR[$0A _S_LEVEL
	.dc.l	scsi_0B_S_DATAINI-jump_00_0F	;SCSIR[$0B _S_DATAINI
	.dc.l	scsi_0C_S_DATAOUTI-jump_00_0F	;SCSIR[$0C _S_DATAOUTI
  .if SCSI_BIOS_LEVEL<=4
	.dc.l	scsi_XX_undefined-jump_00_0F	;SCSIR[$0D _S_MSGOUTEXT
  .else
	.dc.l	scsi_0D_S_MSGOUTEXT-jump_00_0F	;SCSIR[$0D _S_MSGOUTEXT
  .endif
	.dc.l	scsi_XX_undefined-jump_00_0F	;SCSIR[$0E
	.dc.l	scsi_XX_undefined-jump_00_0F	;SCSIR[$0F

;SCSIR[$20`$3F̃Wve[u
jump_20_3F:
	.dc.l	scsi_20_S_INQUIRY-jump_20_3F	;SCSIR[$20 _S_INQUIRY
	.dc.l	scsi_21_S_READ-jump_20_3F	;SCSIR[$21 _S_READ
	.dc.l	scsi_22_S_WRITE-jump_20_3F	;SCSIR[$22 _S_WRITE
	.dc.l	scsi_23_S_FORMAT-jump_20_3F	;SCSIR[$23 _S_FORMAT
	.dc.l	scsi_24_S_TESTUNIT-jump_20_3F	;SCSIR[$24 _S_TESTUNIT
	.dc.l	scsi_25_S_READCAP-jump_20_3F	;SCSIR[$25 _S_READCAP
	.dc.l	scsi_26_S_READEXT-jump_20_3F	;SCSIR[$26 _S_READEXT
	.dc.l	scsi_27_S_WRITEEXT-jump_20_3F	;SCSIR[$27 _S_WRITEEXT
	.dc.l	scsi_28_S_VERIFYEXT-jump_20_3F	;SCSIR[$28 _S_VERIFYEXT
	.dc.l	scsi_29_S_MODESENSE-jump_20_3F	;SCSIR[$29 _S_MODESENSE
	.dc.l	scsi_2A_S_MODESELECT-jump_20_3F	;SCSIR[$2A _S_MODESELECT
	.dc.l	scsi_2B_S_REZEROUNIT-jump_20_3F	;SCSIR[$2B _S_REZEROUNIT
	.dc.l	scsi_2C_S_REQUEST-jump_20_3F	;SCSIR[$2C _S_REQUEST
	.dc.l	scsi_2D_S_SEEK-jump_20_3F	;SCSIR[$2D _S_SEEK
	.dc.l	scsi_2E_S_READI-jump_20_3F	;SCSIR[$2E _S_READI
	.dc.l	scsi_2F_S_STARTSTOP-jump_20_3F	;SCSIR[$2F _S_STARTSTOP
	.dc.l	scsi_30_S_SEJECT-jump_20_3F	;SCSIR[$30 _S_SEJECT
	.dc.l	scsi_31_S_REASSIGN-jump_20_3F	;SCSIR[$31 _S_REASSIGN
	.dc.l	scsi_32_S_PAMEDIUM-jump_20_3F	;SCSIR[$32 _S_PAMEDIUM
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$33
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$34
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$35
	.dc.l	scsi_36_S_DSKINI-jump_20_3F	;SCSIR[$36 _S_DSKINI
	.dc.l	scsi_37_S_FORMATB-jump_20_3F	;SCSIR[$37 _S_FORMATB
	.dc.l	scsi_38_S_BADFMT-jump_20_3F	;SCSIR[$38 _S_BADFMT
	.dc.l	scsi_39_S_ASSIGN-jump_20_3F	;SCSIR[$39 _S_ASSIGN
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3A
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3B
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3C
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3D
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3E
	.dc.l	scsi_XX_undefined-jump_20_3F	;SCSIR[$3F

;SCSIR[$40`$4F̃Wve[u
jump_40_4F:
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$40
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$41
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$42
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$43
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$44
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$45
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$46
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$47
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$48
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$49
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4A
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4B
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4C
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4D
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4E
	.dc.l	scsi_XX_undefined-jump_40_4F	;SCSIR[$4F



;--------------------------------------------------------------------------------
;	.include	sc06iocs2.s
;--------------------------------------------------------------------------------

;----------------------------------------------------------------
;SCSIR[$00 _S_RESET SPC̏SCSIoXZbg
scsi_00_S_RESET:
	push	d1/a1/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;n[hEFAZbgJn
	move.b	#SPC_SCTL_RD|SPC_SCTL_AE,SPC_SCTL(aSPC)	;A[rg[VtF[Y(SCSI)
  .if 10<=SCSI_BIOS_LEVEL
	sf.b	BIOS_SCSI_NOT_CONFLICT.w	;SCSI-IDՓˊmFB$00=mF,$FF=mFς
  .endif
;SRAM
	move.b	SRAM_SCSI_MAGIC,d0	;SCSI}WbNB'V'($56)=ς
	if	<cmpi.b #'V',d0>,ne	;SRAM
		move.b	#$31,SYSPORT_SRAM	;SRAMݐB$31=,̑=֎~
  .if (SCSI_BIOS_LEVEL<=0)|(10<=SCSI_BIOS_LEVEL)
    .if SCSIEXROM
		move.b	#$0F,SRAM_SCSI_MODE	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
    .else
		move.b	#$07,SRAM_SCSI_MODE	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
    .endif
  .else
		if	<cmpa.l #SPC_IN_BASE,aSPC>,eq	;
			move.b	#$07,SRAM_SCSI_MODE	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
		else				;g
			move.b	#$0F,SRAM_SCSI_MODE	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
		endif
  .endif
		move.b	#$00,SRAM_SCSI_SASI_FLAG	;SASItO
		move.b	#'V',SRAM_SCSI_MAGIC	;SCSI}WbNB'V'($56)=ς
		move.b	#$00,SYSPORT_SRAM	;SRAMݐB$31=,̑=֎~
	endif
;SRAMς
;{̂SCSI-IDݒ肷
	move.b	SRAM_SCSI_MODE,d0	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
	andi.b	#7,d0			;{̂SCSI-ID
	move.b	d0,SPC_BDID(aSPC)
;SPC̃WX^NA
	moveq.l	#0,d0
	move.b	d0,SPC_SCMD(aSPC)
	move.b	d0,SPC_PCTL(aSPC)
	move.b	d0,SPC_TCH(aSPC)
	move.b	d0,SPC_TCM(aSPC)
	move.b	d0,SPC_TCL(aSPC)
	move.b	d0,SPC_TEMP(aSPC)
  .if 10<=SCSI_BIOS_LEVEL
	move.b	#$00,SPC_SDGC(aSPC)
	move.w	#512,BIOS_SCSI_BLOCK_SIZE.w	;SCSI@̃ubNTCY
  .endif
;SPC荞݂ݒ肷
  .if SCSI_BIOS_LEVEL<=4
	moveq.l	#_B_INTVCS,d0
    .if SCSI_BIOS_LEVEL<=0
	moveq.l	#OFFSET_SPC_IN/4,d1	;SPC荞݃xN^
    .else
	if	<cmpa.l #SPC_IN_BASE,aSPC>,eq	;
		moveq.l	#OFFSET_SPC_IN/4,d1	;SPC荞݃xN^
	else				;g
		move.l	#OFFSET_SPC_EX/4,d1	;gSPC荞݃xN^
	endif
    .endif
	lea.l	spc_interrupt_routine(pc),a1	;SPC荞݃[`
	trap	#15
  .else
    .if SCSIEXROM
	moveq.l	#OFFSET_SPC_EX/4,d1	;gSPC荞݃xN^
    .else
	moveq.l	#OFFSET_SPC_IN/4,d1	;SPC荞݃xN^
    .endif
	lea.l	spc_interrupt_routine(pc),a1	;SPC荞݃[`
	IOCS	_B_INTVCS
  .endif
;n[hEFAZbgI
	move.b	#SPC_SCTL_AE,SPC_SCTL(aSPC)	;A[rg[VtF[Y(SCSI)
  .if SCSI_BIOS_LEVEL<=4
	move.b	#$00,SPC_SDGC(aSPC)
  .endif
  .if SCSI_BIOS_LEVEL<=3
	move.w	d0,-(sp)
    .if SCSI_BIOS_LEVEL<=0
	move.w	#81-1,d0		;97.2us@10MHz
    .else
	move.w	#129-1,d0		;154.8us@10MHz
    .endif
	for	d0
	next
	move.w	(sp)+,d0
  .endif
  .if 4<=SCSI_BIOS_LEVEL
	moveq.l	#100/50,d0		;100us
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
;SCSIoXZbgJn
	move.b	#SPC_SCMD_RO,SPC_SCMD(aSPC)
  .if SCSI_BIOS_LEVEL<=3
	move.w	d0,-(sp)
    .if SCSI_BIOS_LEVEL<=0
	move.w	#201-1,d0		;241.2us@10MHz
    .else
	move.w	BIOS_MPU_SPEED_ROM.l,d0	;MPUNbNBX6800010MHz*250/3=833AX6803025MHz*500/3=4167B1msԂdbra̋󃋁[v邩
	lsr.w	#2,d0			;250us
    .endif
	for	d0
	next
	move.w	(sp)+,d0
  .endif
  .if 4<=SCSI_BIOS_LEVEL
	moveq.l	#250/50,d0		;250us
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
;SCSIoXZbgI
	move.b	#$00,SPC_SCMD(aSPC)
  .if SCSI_BIOS_LEVEL<=3
	move.w	#2000/10,d0		;2s
	for	d0
		move.w	d0,-(sp)
    .if SCSI_BIOS_LEVEL<=0
		move.w	#1000*10,d0		;10ms
    .else
		move.w	BIOS_MPU_SPEED_ROM.l,d0	;MPUNbNBX6800010MHz*250/3=833AX6803025MHz*500/3=4167B1msԂdbra̋󃋁[v邩
		mulu.w	#10,d0			;10ms
    .endif
		for	d0
		next
		move.w	(sp)+,d0
	next
  .else
	move.l	#2000000/50,d0		;2s
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
  .if 16<=SCSI_BIOS_LEVEL
;SCSIς݃tOZbg
    .if SCSIEXROM
	bset.b	#1,BIOS_SCSI_INITIALIZED.w
    .else
	bset.b	#0,BIOS_SCSI_INITIALIZED.w
    .endif
  .endif
	pop
	rts

;----------------------------------------------------------------
;SPC荞݃[`
spc_interrupt_routine:
	push	d0/d1/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
	move.b	SPC_INTS(aSPC),d0
	move.b	d0,SPC_INTS(aSPC)	;INTSNA
	pop
	rte

;----------------------------------------------------------------
;SCSIR[$02 _S_SELECTA
;	A[rg[VtF[YƃZNVtF[Y(bZ[WAEgtF[Y)
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:IR[hB0=I,̑=(INTS<<16)|PSNS
scsi_02_S_SELECTA:
  .if SCSI_BIOS_LEVEL<=4
ints	reg	SPC_INTS(aSPC)
	push	dID/d7/aSPC
  .else
aINTS	reg	a0
ints	reg	(a0)
	push	dID/d7/aINTS/aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
  .if 10<=SCSI_BIOS_LEVEL
	lea.l	SPC_INTS(aSPC),aINTS
  .endif
	move.b	#SPC_PCTL_SR_S,SPC_PCTL(aSPC)	;SelectR}h̓ZNV
;݂̃R}hI܂ő҂
	do
		move.b	SPC_SSTS(aSPC),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP|SPC_SSTS_SRIN,d0
	while	ne
  .if 10<=SCSI_BIOS_LEVEL
	move.b	ints,ints		;INTSNA
  .endif
	move.b	#SPC_SCMD_CC_SA,SPC_SCMD(aSPC)	;Set ATN
  .if SCSI_BIOS_LEVEL<=0
	jmp	select_common		;_S_SELECTA_S_SELECTA
  .else
	goto	select_common		;_S_SELECTA_S_SELECTA
  .endif

;----------------------------------------------------------------
;SCSIR[$01 _S_SELECT
;	A[rg[VtF[YƃZNVtF[Y(bZ[WAEgtF[YȂ)
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:IR[hB0=I,̑=(INTS<<16)|PSNS
scsi_01_S_SELECT:
	push_again
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
  .if 10<=SCSI_BIOS_LEVEL
	lea.l	SPC_INTS(aSPC),aINTS
  .endif
	move.b	#SPC_PCTL_SR_S,SPC_PCTL(aSPC)	;SelectR}h̓ZNV
;݂̃R}hI܂ő҂
	do
		move.b	SPC_SSTS(aSPC),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP|SPC_SSTS_SRIN,d0
	while	ne
;_S_SELECTA_S_SELECTA
select_common:
	andi.w	#7,dID			;^[QbgSCSI-ID
  .if SCSI_BIOS_LEVEL<=4
	move.b	#1,d0
  .else
	moveq.l	#1,d0
  .endif
	lsl.b	dID,d0
	if	<btst.b dID,SRAM_SCSI_SASI_FLAG>,eq	;SCSI@
		or.b	SPC_BDID(aSPC),d0	;^[QbgSCSI-IDƖ{̂SCSI-ID킹
  .if SCSI_BIOS_LEVEL<=4
		move.b	#SPC_SCTL_AE,SPC_SCTL(aSPC)	;A[rg[VtF[Y(SCSI)
  .else
		bset.b	#SPC_SCTL_AE_BIT,SPC_SCTL(aSPC)	;A[rg[VtF[Y(SCSI)
  .endif
	else				;SASI@
  .if SCSI_BIOS_LEVEL<=4
		move.b	#$00,SPC_SCTL(aSPC)	;A[rg[VtF[YȂ(SASI)
  .else
		bclr.b	#SPC_SCTL_AE_BIT,SPC_SCTL(aSPC)	;A[rg[VtF[YȂ(SASI)
  .endif
	endif
;҂ԂƃA[rg[VJnxԂݒ肷
;	҂
;		(9*65536+196*256+15)*200ns*2=256.006us
;	A[rg[VJnx
;		(3+6)*200ns`(3+7)*200ns=1.8us`2us
  .if (SCSI_BIOS_LEVEL<=4)|(16<=SCSI_BIOS_LEVEL)
	move.b	d0,SPC_TEMP(aSPC)	;^[QbgSCSI-IDƎSCSI-ID킹
	move.w	#(9<<8)|196,d0
	move.b	d0,SPC_TCM(aSPC)	;196
	lsr.w	#8,d0
	move.b	d0,SPC_TCH(aSPC)	;9
	move.b	#3,SPC_TCL(aSPC)	;3
  .else
	swap.w	d0			;mask<<16
	move.w	#(9<<8)|196,d0		;(mask<<16)|(9<<8)|196
	lsl.l	#8,d0			;(mask<<24)|(9<<16)|(196<<8)
	move.b	#3,d0			;(mask<<24)|(9<<16)|(196<<8)|3
	movep.l	d0,SPC_TEMP(aSPC)	;^[QbgSCSI-IDƎSCSI-ID킹
					;9
					;196
					;3
  .endif
	move.b	ints,ints		;INTSNA
;ZNVJn
	move.b	#SPC_SCMD_CC_SL,SPC_SCMD(aSPC)
  .if SCSI_BIOS_LEVEL<=3
	move.w	d0,-(sp)
    .if SCSI_BIOS_LEVEL<=0
	move.w	#13-1,d0		;15.6us@10MHz
    .else
	move.w	#25-1,d0		;30us@10MHz
    .endif
	for	d0
	next
	move.w	(sp)+,d0
  .endif
  .if 4<=SCSI_BIOS_LEVEL
	moveq.l	#50/50,d0		;50us
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
  .if SCSI_BIOS_LEVEL<=3
	move.b	SPC_INTS(aSPC),d0
	if	eq
		move.b	SPC_SSTS(aSPC),d0
		goto	<btst.l #SPC_SSTS_INIT_BIT,d0>,eq,select_common	;CjVG[^ɂȂĂȂBZNVsBA[rg[V蒼
	endif
  .elif SCSI_BIOS_LEVEL==4
;荞݂҂
	do
		move.b	ints,d0
		break	ne				;荞݂
	;+++++ BUG +++++
	;BUSY=0ł~܂悤ɂ悤btst.bmove.bɂȂĂ
	;SSTS̃rbg5eXgSSTS5ł
	;neȂ̂BUSY=0ł͎~܂Ȃ
	;[v̏o1̂Ŗ[vɂȂ炸ɍςł
		move.b	#SPC_SSTS_BUSY_BIT,SPC_SSTS(aSPC)
	;+++++ BUG +++++
	while	ne
  .else
;BUSY=0܂͊荞݂҂
	do
		move.b	ints,d0
		break	ne				;荞݂
		redo	<btst.b #SPC_SSTS_BUSY_BIT,SPC_SSTS(aSPC)>,ne
		goto	<tst.b SPC_SSTS(aSPC)>,pl,select_common	;SPC_SSTS_INIT_BIT
								;BUSY=0CjVG[^ɂȂĂȂBZNVsBA[rg[V蒼
	while	f
  .endif
;荞݂҂
	do
  .if SCSI_BIOS_LEVEL==4
		move.b	SPC_SSTS(aSPC),d0
		goto	<btst.l #SPC_SSTS_INIT_BIT,d0>,eq,select_common	;CjVG[^ɂȂĂȂBZNVsBA[rg[V蒼
  .endif
		move.b	ints,d0
	while	eq
	goto	<cmp.b #SPC_INTS_TO,d0>,eq,selection_timeout	;ZNV^CAEg
  .if SCSI_BIOS_LEVEL<=4
	move.b	d0,ints			;INTSNA
  .else
	move.b	ints,ints		;INTSNA
  .endif
	goto	<cmp.b #SPC_INTS_CC,d0>,eq,selection_no_error	;R}hIBZNVI
;ZNVG[I
selection_error:
	swap.w	d0
	move.b	SPC_PSNS(aSPC),d0
;ZNVI
selection_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

;ZNVI
selection_no_error:
	moveq.l	#0,d0
  .if SCSI_BIOS_LEVEL<=4
	pop_test
	rts
  .else
	goto	selection_end		;ZNVI
  .endif

  .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;ǂQƂĂȂ
	moveq.l	#-1,d0
    .if SCSI_BIOS_LEVEL<=4
	pop
	rts
    .else
	goto	selection_end		;ZNVI
    .endif
;+++++ BUG +++++
  .endif

;ZNV^CAEg
;	ZNV҂Ď
;		((0<<16)|(2<<8)|88)*200ns*2=240us
selection_timeout:
  .if SCSI_BIOS_LEVEL==4
	moveq.l	#50/50,d0
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
  .if (SCSI_BIOS_LEVEL<=4)|(16<=SCSI_BIOS_LEVEL)
	move.b	#0,SPC_TEMP(aSPC)	;0
	move.l	#(0<<16)|(2<<8)|88,d0
	move.b	d0,SPC_TCL(aSPC)	;88
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)	;2
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)	;0
  .else
	move.l	#(0<<16)|(2<<8)|88,d0
	movep.l	d0,SPC_TEMP(aSPC)	;0
					;0
					;2
					;88
  .endif
	move.b	#SPC_INTS_TO,ints	;^CAEgNA
  .if 4<=SCSI_BIOS_LEVEL
	moveq.l	#100/50,d0		;100us
	bsr	wait_50us		;50usPʂ̃EFCg
  .endif
;荞݂҂
	do
		move.b	ints,d0
	while	eq
  .if SCSI_BIOS_LEVEL<=4
	move.b	d0,ints			;INTSNA
  .else
	move.b	ints,ints		;INTSNA
  .endif
	goto	<cmp.b #SPC_INTS_TO,d0>,eq,selection_timeout_2nd	;ZNV^CAEg(2)
	goto	<cmp.b #SPC_INTS_CC,d0>,eq,selection_no_error	;R}hIBZNVI
;R}hIł͂Ȃ
	goto	selection_error		;ZNVG[I

;ZNV^CAEg(2)
selection_timeout_2nd:
;BUSY=0҂
	do
		btst.b	#SPC_SSTS_BUSY_BIT,SPC_SSTS(aSPC)
	while	ne
	move.b	ints,ints		;INTSNA
  .if SCSI_BIOS_LEVEL<=4
	goto	<btst.b #SPC_SSTS_INIT_BIT,SPC_SSTS(aSPC)>,ne,selection_no_error	;CjVG[^BZNVI
  .else
	goto	<tst.b SPC_SSTS(aSPC)>,mi,selection_no_error	;SPC_SSTS_INIT_BIT
								;CjVG[^BZNVI
  .endif
;CjVG[^ł͂Ȃ
	goto	selection_error		;ZNVG[I

;----------------------------------------------------------------
;SCSIR[$03 _S_CMDOUT
;	R}hAEgtF[Y
;<dLEN.l:R}h̒BO[v0,1,5͕svBO[v06oCgAO[v110oCgAO[v512oCg
;<a1.l:R}h̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_03_S_CMDOUT:
	push	dLEN/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
	move.b	(a1),d0
	andi.b	#7<<5,d0
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.b #0.shl.5,d0>,eq,cmdout_group_0	;O[v0($00-$1F)
  .else
	goto	eq,cmdout_group_0	;O[v0($00-$1F)
  .endif
	goto	<cmp.b #1.shl.5,d0>,eq,cmdout_group_1	;O[v1($20-$3F)
	goto	<cmp.b #5.shl.5,d0>,eq,cmdout_group_5	;O[v5($A0-$BF)
	goto	cmdout_go

;O[v0($00-$1F)
cmdout_group_0:
	moveq.l	#6,dLEN			;O[v0̃R}h6oCg
	goto	cmdout_go

;O[v1($20-$3F)
cmdout_group_1:
	moveq.l	#10,dLEN		;O[v1̃R}h10oCg
	goto	cmdout_go

;O[v5($A0-$BF)
cmdout_group_5:
	moveq.l	#12,dLEN		;O[v5̃R}h12oCg
cmdout_go:
;REQ=1҂
	do
  .if SCSI_BIOS_LEVEL<=4
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,cmdout_disconnected	;ؒf
  .else
		goto	<btst.b #SPC_INTS_DC_BIT,SPC_INTS(aSPC)>,ne,cmdout_disconnected	;ؒf
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
	goto	<cmpi.b #SPC_CMDOUT_PHASE,d0>,ne,cmdout_error	;R}hAEgtF[Ył͂ȂBG[I
	bsr	dataout_cpu		;CPU]ŏo͂
	swap.w	d0
	goto	ne,cmdout_error		;]sBG[I
cmdout_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

;G[I
cmdout_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	pop_test
	rts
  .else
	goto	cmdout_end
  .endif

;ؒf
cmdout_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	pop
	rts
  .else
	goto	cmdout_end
  .endif

;----------------------------------------------------------------
;SCSIR[$0C _S_DATAOUTI
;	f[^AEgtF[Y(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_0C_S_DATAOUTI:
  .if SCSI_BIOS_LEVEL<=10
	pushm	aSPC
  .else
	push	aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;REQ=1҂
	do
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,dataouti_disconnected	;ؒf
  .if 10<=SCSI_BIOS_LEVEL
		goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,dataouti_error
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0	;SPC_DATAOUT_PHASE
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_DATAOUT_PHASE,d0>,ne,dataouti_error	;f[^AEgtF[Ył͂ȂBG[I
  .else
	goto	ne,dataouti_error	;f[^AEgtF[Ył͂ȂBG[I
  .endif
	bsr	dataouti_transfer	;SCSIo(\tg])
	swap.w	d0
	goto	ne,dataouti_error	;]sBG[I
dataouti_end:
  .if SCSI_BIOS_LEVEL<=4
	popm_test
  .elif SCSI_BIOS_LEVEL<=10
	popm
  .else
	pop
  .endif
	rts

;G[I
dataouti_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	popm_test
	rts
  .else
	goto	dataouti_end
  .endif

;ؒf
dataouti_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	popm
	rts
  .else
	goto	dataouti_end
  .endif

;----------------------------------------------------------------
;SCSIR[$0B _S_DATAINI
;	f[^CtF[Y(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_0B_S_DATAINI:
  .if SCSI_BIOS_LEVEL<=10
	pushm	aSPC
  .else
	push	aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;REQ=1҂
	do
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,dataini_disconnected	;ؒf
  .if 10<=SCSI_BIOS_LEVEL
		goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,dataini_error
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_DATAIN_PHASE,d0>,ne,dataini_error	;f[^CtF[Ył͂ȂBG[I
  .else
	goto	<cmpi.b #SPC_DATAIN_PHASE,d0>,ne,dataini_error	;f[^CtF[Ył͂ȂBG[I
  .endif
	bsr	dataini_transfer	;SCSI(\tg])
	swap.w	d0
	goto	ne,dataini_error	;]sBG[I
dataini_end:
  .if SCSI_BIOS_LEVEL<=4
	popm_test
  .elif SCSI_BIOS_LEVEL<=10
	popm
  .else
	pop
  .endif
	rts

;G[I
dataini_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	popm_test
	rts
  .else
	goto	dataini_end
  .endif

;ؒf
dataini_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	popm
	rts
  .else
	goto	dataini_end
  .endif

;----------------------------------------------------------------
;SCSIR[$06 _S_STSIN
;	Xe[^XCtF[Y
;	Xe[^XoCg
;		$00 --00000-	Good
;		$02 --00001-	Check Condition
;		$04 --00010-	Condition Met
;		$08 --00100-	Busy
;		$10 --01000-	Intermediate
;		$14 --01010-	Intermediate-Condition Met
;		$18 --01100-	Reservation Conflict
;		$22 --10001-	Command Terminated
;		$28 --10100-	Queue Full
;		̑		U[u
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_06_S_STSIN:
	push	dLEN/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;REQ=1҂
	do
  .if SCSI_BIOS_LEVEL<=4
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,stsin_disconnected	;ؒf
  .else
		goto	<btst.b #SPC_INTS_DC_BIT,SPC_INTS(aSPC)>,ne,stsin_disconnected	;ؒf
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_STSIN_PHASE,d0>,ne,stsin_error	;Xe[^XCtF[Ył͂ȂBG[I
  .else
	goto	<cmpi.b #SPC_STSIN_PHASE,d0>,ne,stsin_error	;Xe[^XCtF[Ył͂ȂBG[I
  .endif
;]
	moveq.l	#1,dLEN			;f[^̒
	bsr	datain_cpu		;CPU]œ͂
	swap.w	d0
	goto	ne,stsin_error		;]sBG[I
stsin_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

;G[I
stsin_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	pop_test
	rts
  .else
	goto	stsin_end
  .endif

;ؒf
stsin_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	pop
	rts
  .else
	goto	stsin_end
  .endif

;----------------------------------------------------------------
;SCSIR[$07 _S_MSGIN
;	bZ[WCtF[Y
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_07_S_MSGIN:
	push	dLEN/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
  .if 10<=SCSI_BIOS_LEVEL
	moveq.l	#1,dLEN			;f[^̒
  .endif
;REQ=1҂
	do
  .if SCSI_BIOS_LEVEL<=4
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,msgin_disconnected	;ؒf
  .else
		goto	<btst.b #SPC_INTS_DC_BIT,SPC_INTS(aSPC)>,ne,msgin_disconnected	;ؒf
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_MSGIN_PHASE,d0>,ne,msgin_error	;bZ[WCtF[Ył͂ȂBG[I
  .else
	goto	<cmpi.b #SPC_MSGIN_PHASE,d0>,ne,msgin_error	;bZ[WCtF[Ył͂ȂBG[I
  .endif
;]
  .if SCSI_BIOS_LEVEL<=4
	moveq.l	#1,dLEN			;f[^̒
  .endif
	bsr	datain_cpu		;CPU]œ͂
	swap.w	d0
	goto	ne,msgin_error	;]sBG[I
msgin_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

;G[I
msgin_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	pop_test
	rts
  .else
	goto	msgin_end
  .endif

;ؒf
msgin_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	pop
	rts
  .else
	goto	msgin_end
  .endif

;----------------------------------------------------------------
;SCSIR[$08 _S_MSGOUT
;	bZ[WAEgtF[Y
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_08_S_MSGOUT:
	push	dLEN/aSPC
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,aSPC
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
  .if 10<=SCSI_BIOS_LEVEL
	moveq.l	#1,dLEN			;f[^̒
  .endif
;_S_MSGOUTA_S_MSGOUTEXT
msgout_common:
;REQ=1҂
	do
  .if SCSI_BIOS_LEVEL<=4
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,msgout_disconnected	;ؒf
  .else
		goto	<btst.b #SPC_INTS_DC_BIT,SPC_INTS(aSPC)>,ne,msgout_disconnected	;ؒf
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_MSGOUT_PHASE,d0>,ne,msgout_error	;bZ[WAEgtF[Ył͂ȂBG[I
  .else
	goto	<cmpi.b #SPC_MSGOUT_PHASE,d0>,ne,msgout_error	;bZ[WAEgtF[Ył͂ȂBG[I
  .endif
;]
  .if SCSI_BIOS_LEVEL<=4
	moveq.l	#1,dLEN			;f[^̒
  .endif
	bsr	dataouti_transfer	;SCSIo(\tg])
	swap.w	d0
	goto	ne,msgout_error
msgout_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

;G[I
msgout_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	pop_test
	rts
  .else
	goto	msgout_end
  .endif

;ؒf
msgout_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	pop
	rts
  .else
	goto	msgout_end
  .endif

  .if 10<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;SCSIR[$0D _S_MSGOUTEXT
;	gbZ[WAEgtF[Y
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,-1=ؒf,̑=(INTS<<16)|PSNS
scsi_0D_S_MSGOUTEXT:
	push	dLEN/aSPC
	movea.l	spc_base_handle(pc),aSPC	;SPCx[Xnh
	move.b	2(aBUF),d0
	goto	eq,msgoutext_0
	subq.b	#2,d0
	goto	cs,msgoutext_1
	goto	eq,msgoutext_2
	subq.b	#1,d0
	goto	eq,msgoutext_2
	goto	msgout_common		;_S_MSGOUTA_S_MSGOUTEXT

msgoutext_0:
	moveq.l	#5,dLEN
	goto	msgoutext_go

msgoutext_1:
	moveq.l	#3,dLEN
	goto	msgoutext_go

msgoutext_2:
	moveq.l	#2,dLEN
msgoutext_go:
	move.b	#1,(aBUF)
	move.b	dLEN,1(aBUF)
	addq.l	#2,dLEN
	goto	msgout_common		;_S_MSGOUTA_S_MSGOUTEXT
  .endif

;----------------------------------------------------------------
;SCSIR[$09 _S_PHASE
;	tF[YZX
;>d0.l:݂̃tF[Y
scsi_09_S_PHASE:
  .if SCSI_BIOS_LEVEL<=10
	pushm	aSPC
  .else
	push	aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,a6
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
	moveq.l	#0,d0
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=10
	popm
  .else
	pop
  .endif
	rts

;----------------------------------------------------------------
;SCSIR[$0A _S_LEVEL
;	o[W
;	o[W3ȉ̂ƂFORMAT.XSCSIn[hfBXNɏSCSIfoCXhCoo[W4ɍւ
;>d0.l:o[W
scsi_0A_S_LEVEL:
	moveq.l	#SCSI_BIOS_LEVEL,d0
	rts


  .if SCSI_BIOS_LEVEL<=4


;----------------------------------------------------------------
;SCSIo(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,̑=INTS
dataouti_transfer:
	push	dLEN/aBUF
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;REQ=1҂
	do
		move.b	SPC_PSNS(aSPC),d0
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
;CjVG[^œ]҂
	do
		move.b	SPC_SSTS(aSPC),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0
		break	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq	;^[Qbgœ]H
	while	<cmp.b #SPC_SSTS_INIT|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,ne
;1oCg]
	do
		break	<tst.b SPC_INTS(aSPC)>,ne	;荞݂
		redo	<btst.b #SPC_SSTS_DF_BIT,SPC_SSTS(aSPC)>,ne	;FIFOtłȂȂ܂ő҂
		move.b	(aBUF)+,SPC_DREG(aSPC)
		subq.l	#1,dLEN
	while	ne
;荞݂҂
	do
		move.b	SPC_INTS(aSPC),d0
	while	eq
	move.b	d0,SPC_INTS(aSPC)	;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,ne
		pop_test
		rts

	endif
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;SCSI(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,̑=INTS
dataini_transfer:
	push	dLEN/aBUF
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
;CjVG[^œ]҂
dataini_wait:
	do
		move.b	SPC_SSTS(aSPC),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0
		break	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq	;^[Qbgœ]H
	while	<cmp.b #SPC_SSTS_INIT|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,ne
;1oCg]
dataini_loop:
;+++++ BUG +++++
;Service RequiredɑΉĂȂ
;	Ō̃f[^𑗐MAACKFalseɂȂ̂҂ɃXe[^XCtF[YɈڍsĂ܂n[hfBXN炵
;	Ō̃f[^FIFOoI܂Ŗ{̂̓f[^CtF[YȂ̂ŁA
;	tF[Y̕svŊ荞ݗvService RequiredZbg\
;	Service RequiredZbgƓ]fĂ܂AFIFOɎcĂŌ̃f[^󂯎葹˂\
;+++++ BUG +++++
	do
	;FIFOłȂȂ܂ő҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataini_interrupted	;荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
	;FIFO1oCgǂݍ
		move.b	SPC_DREG(aSPC),(aBUF)+
		subq.l	#1,dLEN
	while	ne
dataini_interrupted:
;荞݂҂
	do
		move.b	SPC_INTS(aSPC),d0
	while	eq
	move.b	d0,SPC_INTS(aSPC)	;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,ne
		pop_test
		rts

	endif
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;CPU]ŏo͂
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0
dataout_cpu:
	push	dLEN/aBUF
dataout_cpu_loop:
	do
	;tF[YZbg
		move.b	SPC_PSNS(aSPC),d0
		andi.b	#SPC_PHASE_MASK,d0
		move.b	d0,SPC_PCTL(aSPC)
	;REQ=1҂
	dataout_cpu_wait_1:
		do
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
	;1oCgo͂
		move.b	(aBUF)+,SPC_TEMP(aSPC)
		move.b	#SPC_SCMD_CC_SR|SPC_SCMD_IT|SPC_SCMD_PT,SPC_SCMD(aSPC)	;Set ACK
	;REQ=0҂
	dataout_cpu_wait_2:
		do
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,ne
		move.b	#SPC_SCMD_CC_RR|SPC_SCMD_IT|SPC_SCMD_PT,SPC_SCMD(aSPC)	;Reset ACK
		subq.l	#1,dLEN
	while	ne
	moveq.l	#0,d0
dataout_cpu_end:
	pop
	rts

;----------------------------------------------------------------
;CPU]œ͂
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0
datain_cpu:
	push	dLEN/aBUF
datain_cpu_loop:
	do
	;tF[YZbg
		move.b	SPC_PSNS(aSPC),d0
		andi.b	#SPC_PHASE_MASK,d0
		move.b	d0,SPC_PCTL(aSPC)
	;REQ=1҂
	datain_cpu_wait_1:
		do
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
		move.b	#SPC_SCMD_CC_SR|SPC_SCMD_IT|SPC_SCMD_PT,SPC_SCMD(aSPC)	;Set ACK
	;REQ=0҂
	datain_cpu_wait_2:
		do
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,ne
	;1oCg͂
		move.b	SPC_TEMP(aSPC),(aBUF)+
		move.b	#SPC_SCMD_CC_RR|SPC_SCMD_IT|SPC_SCMD_PT,SPC_SCMD(aSPC)	;Reset ACK
		subq.l	#1,dLEN
	while	ne
	moveq.l	#0,d0
	pop
	rts


  .else


;----------------------------------------------------------------
;SCSIo(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,̑=INTS
dataouti_transfer:
aINTS	reg	a2
aSSTS	reg	a3
aDREG	reg	a4
	push	d1/d2/dLEN/dID/aBUF/aINTS/aSSTS/aDREG
	lea.l	SPC_INTS(aSPC),aINTS
	lea.l	SPC_SSTS(aSPC),aSSTS
	lea.l	SPC_DREG(aSPC),aDREG
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;Zbg
    .if SCSI_BIOS_LEVEL<=10
	move.l	#$00FFFFFF,d0
	and.l	dLEN,d0
	movep.l	d0,SPC_TEMP(aSPC)
    .else
	move.b	#0,SPC_TEMP(aSPC)
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
    .endif
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;REQ=1҂
	do
	while	<tst.b SPC_PSNS(aSPC)>,pl	;SPC_PSNS_REQ_BIT
;]Jn
	move.b	(aINTS),(aINTS)		;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
;CjVG[^œ]҂
	do
		move.b	(aSSTS),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0
    .if SCSI_BIOS_LEVEL<=10
	;+++++ BUG +++++
	;^[QbĝƂ[vJE^d2ݒ肹Ƀ[vɔэł
		goto	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq,dataouti_target	;^[Qbgœ]H
	;+++++ BUG +++++
    .else
		break	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq	;^[Qbgœ]H
    .endif
	while	<cmp.b #SPC_SSTS_INIT|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,ne	;CjVG[^œ]҂

    .if SCSI_BIOS_LEVEL<=10

;CjVG[^œ]
	move.l	dLEN,d0
	lsr.l	#3,d0			;/8
	goto	eq,dataouti_less_than_8	;8oCg
;8oCgȏ
;<d0.l:/8
	move.l	d0,d2
dataouti_target:
;8oCg]
	do
	;FIFOɂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataouti_finish	;荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,(aSSTS)>,eq	;FIFOɂȂ܂ő҂
	;FIFO8oCg
	;+++++ BUG +++++
	;68000Ńobt@̃AhX̂ƂAhXG[
	;+++++ BUG +++++
		move.l	(aBUF)+,d0
		move.b	d0,d1
		rol.l	#8,d0
		move.b	d0,(aDREG)
		rol.l	#8,d0
		move.b	d0,(aDREG)
		rol.l	#8,d0
		move.b	d0,(aDREG)
		move.b	d1,(aDREG)
	;+++++ BUG +++++
	;68000Ńobt@̃AhX̂ƂAhXG[
	;+++++ BUG +++++
		move.l	(aBUF)+,d0
		move.b	d0,d1
		rol.l	#8,d0
		move.b	d0,(aDREG)
		rol.l	#8,d0
		move.b	d0,(aDREG)
		rol.l	#8,d0
		move.b	d0,(aDREG)
		move.b	d1,(aDREG)
		subq.l	#1,d2
	while	ne
;8oCg
dataouti_less_than_8:
	and.w	#7,dLEN
	beq	dataouti_finish
;1oCg]
	subq.w	#1,dLEN
	for	dLEN
		break	<tst.b (aINTS)>,ne	;荞݂
		redo	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,ne	;FIFOtłȂȂ܂ő҂
		move.b	(aBUF)+,(aDREG)
	next
;n
dataouti_finish:
	do
		move.b	(aINTS),d0
	while	eq			;荞݂҂
	move.b	d0,(aINTS)		;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,eq
		moveq.l	#0,d0
	endif
;+++++ BUG +++++
;INTSԂƂd0.l̏ʃoCgɃS~
;+++++ BUG +++++
	pop
	rts

    .else

	move.w	aBUF,d0
	gotoand	<lsr.w #1,d0>,cs,<is68000 d0>,eq,dataouti_1byte	;aBUF68000łB1oCg]
;aBUF܂68000łȂ
;8oCg]
	while	<subq.l #8,dLEN>,hs
		goto	<tst.b (aINTS)>,ne,dataouti_finish	;荞݂
		redo	<btst.b #SPC_SSTS_DE_BIT,(aSSTS)>,eq	;FIFOɂȂ܂ő҂
	;8oCg]BrFIFOtɂȂĂȂmFȂ
	  .rept 2
		move.l	(aBUF)+,d0
	    .rept 4
		rol.l	#8,d0
		move.b	d0,(aDREG)
	    .endm
	  .endm
	endwhile
	addq.l	#8,dLEN
;1oCg]
dataouti_1byte:
	while	<subq.l #1,dLEN>,hs
		goto	<tst.b (aINTS)>,ne,dataouti_finish	;荞݂
		redo	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,ne	;FIFOtłȂȂ܂ő҂
	;1oCg]
		move.b	(aBUF)+,(aDREG)
	endwhile
;n
dataouti_finish:
	moveq.l	#0,d0
	do
		move.b	(aINTS),d0
	while	eq			;荞݂҂
	move.b	d0,(aINTS)		;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,eq	;Command Complete
		moveq.l	#0,d0
	endif
	pop
	rts

    .endif

;----------------------------------------------------------------
;SCSI(\tg])
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0=I,̑=INTS
dataini_transfer:
aINTS	reg	a2
aSSTS	reg	a3
aDREG	reg	a4
	push	d1/d2/dLEN/aBUF/aINTS/aSSTS/aDREG
	lea.l	SPC_INTS(aSPC),aINTS
	lea.l	SPC_SSTS(aSPC),aSSTS
	lea.l	SPC_DREG(aSPC),aDREG
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
    .if SCSI_BIOS_LEVEL<=10
	move.l	#$00FFFFFF,d0
	and.l	dLEN,d0
	movep.l	d0,SPC_TEMP(aSPC)
    .else
	move.b	#0,SPC_TEMP(aSPC)
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
    .endif
;]Jn
	move.b	(aINTS),(aINTS)		;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
;CjVG[^œ]҂
	do
		move.b	(aSSTS),d0
		andi.b	#SPC_SSTS_INIT|SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0
    .if SCSI_BIOS_LEVEL<=10
	;+++++ BUG +++++
	;^[QbĝƂ[vJE^d2ݒ肹Ƀ[vɔэł
		goto	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq,dataini_target	;^[Qbgœ]H
	;+++++ BUG +++++
    .else
		break	<cmp.b #SPC_SSTS_TARG|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,eq	;^[Qbgœ]H
    .endif
	while	<cmp.b #SPC_SSTS_INIT|SPC_SSTS_BUSY|SPC_SSTS_TRIP,d0>,ne	;CjVG[^œ]҂

    .if SCSI_BIOS_LEVEL<=10

;CjVG[^œ]
	goto	<tst.b SRAM_SCSI_MODE>,mi,dataini_block_transfer	;SCSIݒBubN|^Cv|o[Xg|\tg|g|{###
									;ubN]
;oCg]
dataini_byte_transfer:
	move.l	dLEN,d0
	lsr.l	#3,d0			;/8
	goto	eq,dataini_less_than_8	;8oCg
;8oCgȏ
;<d0.l:/8
	move.l	d0,d2
dataini_target:
;8oCg]
	do
	;FIFOtɂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataini_finish	;荞݂
		while	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,eq
	;FIFO8oCgǂݍ
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
	;+++++ BUG +++++
	;68000Ńobt@̃AhX̂ƂAhXG[
	;+++++ BUG +++++
		move.l	d0,(aBUF)+
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
		lsl.l	#8,d0
		move.b	(aDREG),d0
	;+++++ BUG +++++
	;68000Ńobt@̃AhX̂ƂAhXG[
	;+++++ BUG +++++
		move.l	d0,(aBUF)+
		subq.l	#1,d2
	while	ne
;8oCg
dataini_less_than_8:
	and.w	#7,dLEN
	goto	eq,dataini_finish
;1oCg]
;+++++ BUG +++++
;Service RequiredɑΉĂȂ
;	Ō̃f[^𑗐MAACKFalseɂȂ̂҂ɃXe[^XCtF[YɈڍsĂ܂n[hfBXN炵
;	Ō̃f[^FIFOoI܂Ŗ{̂̓f[^CtF[YȂ̂ŁA
;	tF[Y̕svŊ荞ݗvService RequiredZbg\
;	Service RequiredZbgƓ]fĂ܂AFIFOɎcĂŌ̃f[^󂯎葹˂\
;+++++ BUG +++++
	subq.w	#1,dLEN
	for	dLEN
		goto	<tst.b (aINTS)>,ne,dataini_finish	;荞݂
		redo	<btst.b #SPC_SSTS_DE_BIT,(aSSTS)>,ne	;FIFO
		move.b	(aDREG),(aBUF)+		;FIFO1oCgǂݍ
	next
;n
dataini_finish:
	do
		move.b	(aINTS),d0
	while	eq			;荞݂҂
	move.b	d0,(aINTS)		;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,eq
		moveq.l	#0,d0
	endif
;+++++ BUG +++++
;INTSԂƂd0.l̏ʃoCgɃS~
;+++++ BUG +++++
	pop
	rts

;ubN]
dataini_block_transfer:
	moveq.l	#0,d2
	move.w	BIOS_SCSI_BLOCK_SIZE.w,d2	;SCSI@̃ubNTCY
	goto	<cmp.l d2,dLEN>,cs,dataini_byte_transfer	;ubNTCYBoCg]
	divu.w	d2,dLEN			;[*$10000+ubN
	lsr.l	#4,d2			;ubNTCY/16
;1ubN]
	subq.l	#1,d2			;ubNTCY/16-1
	do
	;FIFOtɂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataini_finish	;荞݂
		while	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,eq
	;FIFO1ubNǂݍށBrFIFOɂȂĂȂmFȂ
		move.w	d2,d1
		for	d1
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
		;+++++ BUG +++++
		;68000Ńobt@̃AhX̂ƂAhXG[
		;+++++ BUG +++++
			move.l	d0,(aBUF)+
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
		;+++++ BUG +++++
		;68000Ńobt@̃AhX̂ƂAhXG[
		;+++++ BUG +++++
			move.l	d0,(aBUF)+
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
		;+++++ BUG +++++
		;68000Ńobt@̃AhX̂ƂAhXG[
		;+++++ BUG +++++
			move.l	d0,(aBUF)+
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
			lsl.l	#8,d0
			move.b	(aDREG),d0
		;+++++ BUG +++++
		;68000Ńobt@̃AhX̂ƂAhXG[
		;+++++ BUG +++++
			move.l	d0,(aBUF)+
		next
		subq.w	#1,dLEN
	while	ne
	swap.w	dLEN			;0*$10000+[
	goto	dataini_byte_transfer	;oCg]

    .else

	move.w	aBUF,d0
	gotoand	<lsr.w #1,d0>,cs,<is68000 d0>,eq,dataini_1byte	;aBUF68000łB1oCg]
;aBUF܂68000łȂ
	goto	<tst.b SRAM_SCSI_MODE>,pl,dataini_8bytes	;SRAM_SCSI_BLOCK_BITBubN]ȂB8oCg]
;ubN]
	moveq.l	#0,d2
	move.w	BIOS_SCSI_BLOCK_SIZE.w,d2	;SCSI@̃ubNTCYB0łȂ16Ŋ؂邱
	while	<sub.l d2,dLEN>,hs
		move.b	(aINTS),d0
		if	ne			;荞݂
			add.l	d2,dLEN
			goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,dataini_1byte	;Service Required̂ƂFIFOɂȂ܂1oCg]
			goto	dataini_finish		;ȊO͒~
		endif
		redo	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,eq	;FIFOtɂȂ܂ő҂
	;1ubN]BrFIFOɂȂĂȂmFȂ
		move.w	d2,d1
		lsr.w	#4,d1
		subq.w	#1,d1			;ubNTCY/16-1
		for	d1
		;16oCg]
		  .rept 4
			move.b	(aDREG),d0
			lsl.w	#8,d0
			move.b	(aDREG),d0
			swap.w	d0
			move.b	(aDREG),d0
			lsl.w	#8,d0
			move.b	(aDREG),d0
			move.l	d0,(aBUF)+
		  .endm
		next
	endwhile
	add.l	d2,dLEN
;8oCg]
dataini_8bytes:
	while	<subq.l #8,dLEN>,hs
		move.b	(aINTS),d0
		if	ne			;荞݂
			addq.l	#8,dLEN
			goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,dataini_1byte	;Service Required̂ƂFIFOɂȂ܂1oCg]
			goto	dataini_finish		;ȊO͒~
		endif
		redo	<btst.b #SPC_SSTS_DF_BIT,(aSSTS)>,eq	;FIFOtɂȂ܂ő҂
	;8oCg]BrFIFOɂȂĂȂmFȂ
	  .rept 2
		move.b	(aDREG),d0
		lsl.w	#8,d0
		move.b	(aDREG),d0
		swap.w	d0
		move.b	(aDREG),d0
		lsl.w	#8,d0
		move.b	(aDREG),d0
		move.l	d0,(aBUF)+
	  .endm
	endwhile
	addq.l	#8,dLEN
;1oCg]
dataini_1byte:
	while	<subq.l #1,dLEN>,hs
		move.b	(aINTS),d0
		if	ne			;荞݂
			ifor	<btst.l #SPC_INTS_SR_BIT,d0>,eq,<btst.b #SPC_SSTS_DE_BIT,(aSSTS)>,ne	;Service RequiredłȂ܂FIFÔƂ
				addq.l	#1,dLEN
				goto	dataini_finish
			endif
			;Service RequiredFIFOłȂƂ荞݂𖳎
		endif
		redo	<btst.b #SPC_SSTS_DE_BIT,(aSSTS)>,ne	;FIFOłȂȂ܂ő҂
	;1oCg]
		move.b	(aDREG),(aBUF)+
	endwhile
	addq.l	#1,dLEN
;n
dataini_finish:
	moveq.l	#0,d0
	do
		move.b	(aINTS),d0
	while	eq			;荞݂҂
	move.b	d0,(aINTS)		;INTSNA
	moveq.l	#.notb.(SPC_INTS_CC|SPC_INTS_SR),d1
	and.b	d0,d1
	ifand	<>,eq,<tst.l dLEN>,eq	;Command Complete܂Service RequiredōŌ܂œ]
		moveq.l	#0,d0
	endif
	pop
	rts

    .endif

;----------------------------------------------------------------
;CPU]ŏo͂
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0
dataout_cpu:
aPSNS	reg	a2
aSCMD	reg	a3
	push	d1/d2/dLEN/aBUF/aPSNS/aSCMD
	lea.l	SPC_PSNS(aSPC),aPSNS
	lea.l	SPC_SCMD(aSPC),aSCMD
	moveq.l	#SPC_SCMD_CC_SR|SPC_SCMD_IT|SPC_SCMD_PT,d1	;Set ACK
	moveq.l	#SPC_SCMD_CC_RR|SPC_SCMD_IT|SPC_SCMD_PT,d2	;Reset ACK
	do
	;tF[YZbg
		move.b	(aPSNS),d0
		andi.b	#SPC_PHASE_MASK,d0
		move.b	d0,SPC_PCTL(aSPC)
	;REQ=1҂
		do
		while	<tst.b (aPSNS)>,pl	;SPC_PSNS_REQ_BIT
	;1oCgo͂
		move.b	(aBUF)+,SPC_TEMP(aSPC)
		move.b	d1,(aSCMD)		;Set ACK
	;REQ=0҂
		do
		while	<tst.b (aPSNS)>,mi	;SPC_PSNS_REQ_BIT
		move.b	d2,(aSCMD)		;Reset ACK
		subq.l	#1,dLEN
	while	ne
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;CPU]œ͂
;<dLEN.l:f[^̒
;<a1.l:obt@̃AhX
;>d0.l:0
datain_cpu:
aPSNS	reg	a2
aSCMD	reg	a3
	push	d1/d2/dLEN/aBUF/aPSNS/aSCMD
	lea.l	SPC_PSNS(aSPC),aPSNS
	lea.l	SPC_SCMD(aSPC),aSCMD
	moveq.l	#SPC_SCMD_CC_SR|SPC_SCMD_IT|SPC_SCMD_PT,d1	;Set ACK
	moveq.l	#SPC_SCMD_CC_RR|SPC_SCMD_IT|SPC_SCMD_PT,d2	;Reset ACK
	do
	;tF[YZbg
		move.b	(aPSNS),d0
		andi.b	#SPC_PHASE_MASK,d0
		move.b	d0,SPC_PCTL(aSPC)
	;REQ=1҂
		do
		while	<tst.b (aPSNS)>,pl	;SPC_PSNS_REQ_BIT
		move.b	d1,(aSCMD)		;Set ACK
	;REQ=0҂
		do
		while	<tst.b (aPSNS)>,mi	;SPC_PSNS_REQ_BIT
	;1oCg͂
		move.b	SPC_TEMP(aSPC),(aBUF)+
		move.b	d2,(aSCMD)		;Reset ACK
		subq.l	#1,dLEN
	while	ne
	moveq.l	#0,d0
	pop
	rts


  .endif


  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Test Unit ReadyR}h
test_unit_ready_command:
	.dc.b	$00			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$24 _S_TESTUNIT
;	eXg
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_24_S_TESTUNIT:
	link.w	a5,#-16
	push	d1/dLEN/d6/a1/a2/a3
  .if SCSI_BIOS_LEVEL<=0
	lea.l	test_unit_ready_command,a2	;Test Unit ReadyR}h
  .else
	lea.l	test_unit_ready_command(pc),a2	;Test Unit ReadyR}h
  .endif
	bsr	no_dataio_command	;f[^CtF[Y^f[^AEgtF[ŶȂ6oCg̃R}h
	pop
	unlk	a5
	rts

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Rezero UnitR}h
rezero_unit_command:
	.dc.b	$01			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2B _S_REZEROUNIT
;	Ԑݒ
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2B_S_REZEROUNIT:
	link.w	a5,#-16
	push	d1/dLEN/d6/a1/a2/a3
  .if SCSI_BIOS_LEVEL<=0
	lea.l	rezero_unit_command,a2	;Rezero UnitR}h
  .else
	lea.l	rezero_unit_command(pc),a2	;Rezero UnitR}h
  .endif
	bsr	no_dataio_command	;f[^CtF[Y^f[^AEgtF[ŶȂ6oCg̃R}h
	pop
	unlk	a5
	rts

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Read(6)R}h
read_6_command_2nd:
	.dc.b	$08			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2E _S_READI
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<a1.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2E_S_READI:
	link.w	a5,#-16
	push	d1/dLEN/d6/a1/a2/a3
	movea.l	a1,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	read_6_command_2nd,a2	;Read(6)R}h
    .else
	lea.l	read_6_command_2nd(pc),a2	;Read(6)R}h
    .endif
	lea.l	-16(a5),a1
  .else
	lea.l	-16(a5),a1
	lea.l	read_6_command_2nd(pc),a2	;Read(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(a1)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	d2,d6
	lea.l	-16(a5),a1
	move.b	d6,3(a1)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(a1)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(a1)		;ubNԍ()
  .else
	lea.l	-16(a5),a1
	move.l	d2,d6
	and.l	#$00FFFFFF,d6
	or.l	d6,(a1)			;ubNԍ
  .endif
	move.b	dLEN,4(a1)		;ubN
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
	goto	<tst.l d0>,ne,readcap_error
;f[^CtF[Y
	lsl.l	#8,dLEN
  .if SCSI_BIOS_LEVEL<=10
	lsl.l	d5,dLEN
  .else
;ubNw4ȏ̂Ƃ3ƌȂ
	moveq.l	#3,d0
	if	<cmp.l d0,d5>,lo
		move.l	d5,d0
	endif
	lsl.l	d0,dLEN
  .endif
	movea.l	a3,a1
  .if SCSI_BIOS_LEVEL<=0
	bsr	scsi_0B_S_DATAINI	;SCSIR[$0B _S_DATAINI
  .else
	bsr	scsi_04_S_DATAIN	;SCSIR[$04 _S_DATAIN
  .endif
;Xe[^XCtF[YƃbZ[WCtF[Y
	goto	<cmpi.l #-1,d0>,eq,readcap_error
  .if 3<=SCSI_BIOS_LEVEL
	if	<cmpi.l #-2,d0>,ne
		bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	readi_end:
    .if SCSI_BIOS_LEVEL<=4
		pop_test
    .else
		pop
    .endif
		unlk	a5
		rts
	endif
  .endif
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
    .if 3<=SCSI_BIOS_LEVEL
	if	<tst.l d0>,eq
		moveq.l	#-2,d0
	endif
    .endif
	pop
	unlk	a5
	rts
  .else
	goto	<tst.l d0>,ne,readi_end
	moveq.l	#-2,d0
	goto	readi_end
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Read CapacityR}h
read_capacity_command:
	.dc.b	$25			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 Reserved
	.dc.b	$00			;8 Reserved#######|PMI
	.dc.b	$00			;9 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$25 _S_READCAP
;	eʊmF
;<dID.l:(LUN<<16)|SCSI-ID
;<a1.l:obt@̃AhX
;	0	_ubNAhX()
;	1	  :
;	2	  :
;	3	_ubNAhX()
;	4	ubN()
;	5	  :
;	6	  :
;	7	ubN()
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_25_S_READCAP:
	link.w	a5,#-16
	push	d1/dLEN/d6/a1/a2/a3
	movea.l	a1,a3
;R}h
	lea.l	-16(a5),a1
  .if SCSI_BIOS_LEVEL<=0
	lea.l	read_capacity_command,a2	;Read CapacityR}h
  .else
	lea.l	read_capacity_command(pc),a2	;Read CapacityR}h
  .endif
	moveq.l	#10-1,d1
	for	d1
		move.b	(a2)+,(a1)+
	next
;ZNVtF[YƃR}hAEgtF[Y
	lea.l	-16(a5),a1
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
	goto	<tst.l d0>,ne,readcap_error
;f[^CtF[Y
	movea.l	a3,a1
	moveq.l	#8,dLEN			;f[^̒
	bsr	scsi_0B_S_DATAINI	;SCSIR[$0B _S_DATAINI
	goto	<cmpi.l #-1,d0>,eq,readcap_error
;Xe[^XCtF[YƃbZ[WCtF[Y
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
readcap_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	unlk	a5
	rts

readcap_error:
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	pop
	unlk	a5
	rts
  .else
	goto	readcap_end
  .endif

;----------------------------------------------------------------
;ZNVtF[YƃR}hAEgtF[Y
;<dID.l:(LUN<<16)|SCSI-ID
;<a1.l:R}h
;>d0.l:0=,-1=s
select_and_cmdout:
	push	d1/dID
;ZNVtF[Y
	move.w	#2-1,d1
	for	d1
		bsr	scsi_01_S_SELECT	;SCSIR[$01 _S_SELECT
  .if SCSI_BIOS_LEVEL<=4
		goto	<tst.l d0>,eq,select_and_cmdout_cmdout
	next
	goto	select_and_cmdout_error
  .else
	next	<tst.l d0>,ne
	goto	ne,select_and_cmdout_error
  .endif
;R}hAEgtF[Y
select_and_cmdout_cmdout:
	swap.w	dID
	lsl.b	#5,dID			;LUN<<5
	or.b	dID,1(a1)		;LUN
	bsr	scsi_03_S_CMDOUT	;SCSIR[$03 _S_CMDOUT
	goto	<tst.l d0>,ne,select_and_cmdout_error
	moveq.l	#0,d0			;
select_and_cmdout_end:
  .if SCSI_BIOS_LEVEL<=4
	pop_test
  .else
	pop
  .endif
	rts

select_and_cmdout_error:
	moveq.l	#-1,d0			;s
  .if SCSI_BIOS_LEVEL<=4
	pop
	rts
  .else
	goto	select_and_cmdout_end
  .endif

;----------------------------------------------------------------
;f[^CtF[Y^f[^AEgtF[ŶȂ6oCg̃R}h
;<a2.l:R}h̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
no_dataio_command:
	lea.l	-16(a5),a1
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(a1)+
	next
	lea.l	-16(a5),a1
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
	goto	<tst.l d0>,ne,stsin_and_msgin_error
;----------------------------------------------------------------
;Xe[^XCtF[YƃbZ[WCtF[Y
;>d0.l:(MSGIN<<16)|STSIN
stsin_and_msgin:
	lea.l	-1(a5),a1
	bsr	scsi_06_S_STSIN		;SCSIR[$06 _S_STSIN
	goto	<tst.l d0>,ne,stsin_and_msgin_error
	lea.l	-2(a5),a1
	bsr	scsi_07_S_MSGIN		;SCSIR[$07 _S_MSGIN
	goto	<tst.l d0>,ne,stsin_and_msgin_error
	move.b	-2(a5),d0		;MSGIN
	swap.w	d0
	move.b	-1(a5),d0		;(MSGIN<<16)|STSIN
	rts

stsin_and_msgin_error:
	moveq.l	#-1,d0
	rts

  .if 4<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;50usPʂ̃EFCg
;<d0.l:(50usP)
wait_50us:
aTCDR	reg	a0
	push	d0/d1/d2/aTCDR
	lea.l	MFP_TCDR,aTCDR
	moveq.l	#0,d1
	move.b	(aTCDR),d1
	move.b	(aTCDR),d1
	do
		moveq.l	#0,d2
		move.b	(aTCDR),d2
		redo	<cmp.b (aTCDR),d2>,cs
		sub.w	d2,d1
		if	cs
			add.w	#200,d1
		endif
		exg.l	d1,d2
		sub.l	d2,d0
	while	hi
	pop
	rts
  .endif



;--------------------------------------------------------------------------------
;	.include	sc07iocs3.s
;--------------------------------------------------------------------------------

;----------------------------------------------------------------
;SCSIR[$05 _S_DATAOUT f[^AEgtF[Y
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_05_S_DATAOUT:
  .if SCSI_BIOS_LEVEL<=10
	pushm	aSPC
  .else
	push	aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,a6
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;REQ=1҂
dataout_wait:
	do
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,dataout_disconnected	;ؒf
  .if 10<=SCSI_BIOS_LEVEL
		goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,dataout_error
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0	;SPC_DATAOUT_PHASE
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_DATAOUT_PHASE,d0>,ne,dataout_error	;f[^AEgtF[Ył͂ȂBG[I
  .else
	goto	ne,dataout_error	;f[^AEgtF[Ył͂ȂBG[I
  .endif
;]Jn
	bsr	dataout_transfer	;SCSIo(DMA])
	swap.w	d0
	if	eq
	dataout_end:
  .if SCSI_BIOS_LEVEL<=4
		popm_test
  .elif SCSI_BIOS_LEVEL<=10
		popm
  .else
		pop
  .endif
		rts
	endif
  .if 3<=SCSI_BIOS_LEVEL
	if	<tst.w d0>,ne
		swap.w	d0
    .if SCSI_BIOS_LEVEL<=4
		popm_test
		rts
    .else
		goto	dataout_end
    .endif
	endif
  .endif
;G[I
dataout_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	popm_test
	rts
  .else
	goto	dataout_end
  .endif

;ؒf
dataout_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	popm
	rts
  .else
	goto	dataout_end
  .endif

;----------------------------------------------------------------
;SCSIR[$04 _S_DATAIN
;	f[^CtF[Y
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_04_S_DATAIN:
  .if SCSI_BIOS_LEVEL<=10
	pushm	aSPC
  .else
	push	aSPC
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	SPC_BASE,a6
  .else
	movea.l	spc_base_handle(pc),aSPC
  .endif
;REQ=1҂
	do
		move.b	SPC_INTS(aSPC),d0
		goto	<btst.l #SPC_INTS_DC_BIT,d0>,ne,datain_disconnected	;ؒf
  .if 10<=SCSI_BIOS_LEVEL
		goto	<btst.l #SPC_INTS_SR_BIT,d0>,ne,datain_error
  .endif
		move.b	SPC_PSNS(aSPC),d0	;SPC_PSNS_REQ_BIT
  .if SCSI_BIOS_LEVEL<=4
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
  .else
	while	pl
  .endif
;tF[YmF
	andi.b	#SPC_PHASE_MASK,d0
  .if SCSI_BIOS_LEVEL<=4
;+++++ BUG +++++
;]Ȗ
	andi.b	#SPC_PHASE_MASK,d0
;+++++ BUG +++++
  .endif
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmp.b #SPC_DATAIN_PHASE,d0>,ne,datain_error	;f[^CtF[Ył͂ȂBG[I
  .else
	goto	<cmpi.b #SPC_DATAIN_PHASE,d0>,ne,datain_error	;f[^CtF[Ył͂ȂBG[I
  .endif
;]Jn
	bsr	datain_transfer		;SCSI(DMA])
	swap.w	d0
	if	eq
	datain_end:
  .if SCSI_BIOS_LEVEL<=4
		popm_test
  .elif SCSI_BIOS_LEVEL<=10
		popm
  .else
		pop
  .endif
		rts

	endif
  .if 3<=SCSI_BIOS_LEVEL
	goto	<tst.w d0>,eq,datain_error
	swap.w	d0
    .if SCSI_BIOS_LEVEL<=4
	popm_test
	rts
    .else
	goto	datain_end
    .endif
  .endif
;G[I
datain_error:
	move.b	SPC_PSNS(aSPC),d0
  .if SCSI_BIOS_LEVEL<=4
	popm_test
	rts
  .else
	goto	datain_end
  .endif

;ؒf
datain_disconnected:
	bsr	scsi_00_S_RESET		;SCSIR[$00 _S_RESET
	moveq.l	#-1,d0
  .if SCSI_BIOS_LEVEL<=4
	popm
	rts
  .else
	goto	datain_end
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;InquiryR}h
inquiry_command:
	.dc.b	$12			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|EVPD
	.dc.b	$00			;2 y[WR[h
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$20 _S_INQUIRY
;	INQUIRYf[^̗v
;	ŏɃAP[V5w肵Ēǉf[^𓾂
;	ăAP[V5+ǉf[^w肵Ēǉf[^𓾂
;<dLEN.l:AP[V
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;	0	NHt@CA###|foCX^CvR[h#####
;		NHt@CA
;			0	WJjbgڑĂ
;			1	WJjbgڑĂȂ
;			3	WJjbg݂Ȃ
;		foCX^CvR[h
;			$00	_CNgANZXfoCXBCfBXNȂ
;			$01	V[PVANZXfoCXBCe[vȂ
;			$02	v^foCX
;			$03	vZbTfoCX
;			$04	CgXfoCXBǋL^fBXNȂ
;			$05	CD-ROMfoCX
;			$06	XLifoCX
;			$07	foCXBC[UufBXNȂ
;			$08	fBA`FWfoCXBCe[vCuAfBXNCuȂ
;			$09	R~jP[VfoCX
;			$84	SHARP MO
;	1	RMB|foCX^CvCq#######
;		RMB
;			0	Œ
;			1	
;	2	ISOo[W##|ECMAo[W###|ANSIo[W###
;		bit7-6	ISOo[W(ʏ0)
;		bit5-3	ECMAo[W(ʏ0)
;		bit2-0	ANSIo[W
;			0	K
;			1	SCSI-1BANSI X3.131-1986
;			2	SCSI-2BANSI X3T9.2/86-109
;	3	AENC|TrmlOP|Reserved##|X|Xf[^`####
;	4	ǉf[^(Ȃ0)
;	5`	ǉf[^
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_20_S_INQUIRY:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	inquiry_command,a2	;InquiryR}h
    .else
	lea.l	inquiry_command(pc),a2	;InquiryR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	inquiry_command(pc),a2	;InquiryR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.b	dLEN,4(aBUF)		;AP[V
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^CtF[Y
	movea.l	a3,aBUF
	bsr	scsi_0B_S_DATAINI	;SCSIR[$0B _S_DATAINI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Request SenseR}h
request_sense_command:
	.dc.b	$03			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2C _S_REQUEST
;	ZXf[^̗v
;<dLEN.l:AP[V
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2C_S_REQUEST:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	request_sense_command,a2	;Request SenseR}h
    .else
	lea.l	request_sense_command(pc),a2	;Request SenseR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	request_sense_command(pc),a2	;Request SenseR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.b	dLEN,4(aBUF)		;AP[V
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^CtF[Y
	movea.l	a3,aBUF
	bsr	scsi_0B_S_DATAINI	;SCSIR[$0B _S_DATAINI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Mode Sense(6)R}h
mode_sense_6_command:
	.dc.b	$1A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|R|DBD|Reserved###
	.dc.b	$00			;2 PC##|y[WR[h######
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$29 _S_MODESENSE
;	[hZX
;<d2.l:(PC<<6)|y[WR[h
;	PC	0	
;		1	ύX\rbg}XN
;		2	ftHg
;		3	ۑ
;	y[WR[h63ׂ͂Ẵp[^y[W擾
;<dLEN.l:AP[VB4ȏ
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;	[hp[^wb_
;	0	[hp[^
;		ԋpłp[^Xg̃oCgB[hp[^wb_܂܂ȂB8̔{
;	1	fBA^Cv
;	2	foCXŗLp[^
;		_CNgANZXfoCX̃foCXŗLp[^
;		WP#|Reserved##|DPOFUA|Reserved####
;		rbg71̂Ƃ݋֎~
;	3	ubNfBXNv^
;		ԋpꂽp[^Xg̃oCgB[hp[^wb_܂܂ȂB8̔{
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_29_S_MODESENSE:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	mode_sense_6_command,a2	;Mode Sense(6)R}h
    .else
	lea.l	mode_sense_6_command(pc),a2	;Mode Sense(6)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	mode_sense_6_command(pc),a2	;Mode Sense(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.b	dLEN,4(aBUF)		;AP[V
  .if 3<=SCSI_BIOS_LEVEL
	move.b	d2,2(aBUF)		;(PC<<6)|y[WR[hBPC:0=,1=ύX\rbg}XN,2=ftHg,3=ۑ
  .endif
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^CtF[Y
	movea.l	a3,aBUF
	bsr	scsi_0B_S_DATAINI	;SCSIR[$0B _S_DATAINI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Mode Select(6)R}h
mode_select_6_command:
	.dc.b	$15			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|PF|Reserved###|SP
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 p[^Xg
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2A _S_MODESELECT
;	[hZNg
;<d2.l:PF<<4|SP
;	PF	0	SCSI-1
;		1	SCSI-2
;	SP	0	ۑȂ
;		1	ۑ
;<dLEN.l:p[^Xg
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2A_S_MODESELECT:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	mode_select_6_command,a2	;Mode Select(6)R}h
    .else
	lea.l	mode_select_6_command(pc),a2	;Mode Select(6)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	mode_select_6_command(pc),a2	;Mode Select(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.b	dLEN,4(aBUF)		;p[^Xg
  .if 3<=SCSI_BIOS_LEVEL
	move.b	d2,1(aBUF)		;PF<<4|SPBPF:0=SCSI-1,1=SCSI-2BSP:0=ۑȂ,1=ۑ
  .endif
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	movea.l	a3,aBUF
	bsr	scsi_0C_S_DATAOUTI	;SCSIR[$0C _S_DATAOUTI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Reassign BlocksR}h
reassign_blocks_command:
	.dc.b	$07			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$31 _S_REASSIGN
;	Ĕzu
;
;fBtFNgXg
;	wb_
;	  0 Reserved
;	  1 Reserved
;	  2 fBtFNgXg4*n()
;	  3 fBtFNgXg4*n()
;	fBtFNgfBXNv^
;	  4+4*0+0 sǃubN̘_ubNAhX()
;	  4+4*0+1   :
;	  4+4*0+2   :
;	  4+4*0+3 sǃubN̘_ubNAhX()
;	    :
;	  4+4*(n-1)+0 sǃubN̘_ubNAhX()
;	  4+4*(n-1)+1   :
;	  4+4*(n-1)+2   :
;	  4+4*(n-1)+3 sǃubN̘_ubNAhX()
;
;<dLEN.l:f[^̒
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_31_S_REASSIGN:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	reassign_blocks_command,a2	;Reassign BlocksR}h
    .else
	lea.l	reassign_blocks_command(pc),a2	;Reassign BlocksR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	reassign_blocks_command(pc),a2	;Reassign BlocksR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
;ZNVtF[YƃR}hAEgtF[Y
	lea.l	-16(a5),aBUF
  .if SCSI_BIOS_LEVEL<=3
;+++++ BUG +++++
;Reserved̃tB[hɏł
	move.b	#8,4(aBUF)
;+++++ BUG +++++
  .endif
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	movea.l	a3,aBUF
	bsr	scsi_0C_S_DATAOUTI	;SCSIR[$0C _S_DATAOUTI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Read(6)R}h
read_6_command:
	.dc.b	$08			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$21 _S_READ
;	ǂݍ
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_21_S_READ:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	read_6_command,a2	;Read(6)R}h
    .else
	lea.l	read_6_command(pc),a2	;Read(6)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	read_6_command(pc),a2	;Read(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	d2,d6
	lea.l	-16(a5),aBUF
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	lea.l	-16(a5),aBUF
	move.l	d2,d6
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
	move.b	dLEN,4(aBUF)		;ubN
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^CtF[Y
	lsl.l	#8,dLEN
  .if SCSI_BIOS_LEVEL<=10
	lsl.l	d5,dLEN
  .else
;ubNw4ȏ̂Ƃ3ƌȂ
	moveq.l	#3,d0
	if	<cmp.l d0,d5>,lo
		move.l	d5,d0
	endif
	lsl.l	d0,dLEN
  .endif
	movea.l	a3,aBUF
  .if SCSI_BIOS_LEVEL<=4
	bsr	scsi_04_S_DATAIN	;SCSIR[$04 _S_DATAIN
  .else
	lea.l	scsi_04_S_DATAIN(pc),a0	;SCSIR[$04 _S_DATAIN
	if	<btst.b #SRAM_SCSI_SOFT_BIT,SRAM_SCSI_MODE>,ne	;\tg
		lea.l	scsi_0B_S_DATAINI(pc),a0	;SCSIR[$0B _S_DATAINI
	endif
	jsr	(a0)
  .endif
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
    .if 3<=SCSI_BIOS_LEVEL
	goto	<cmpi.l #-2,d0>,eq,writeext_error_2
    .endif
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_2	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Write(6)R}h
write_6_command:
	.dc.b	$0A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$22 _S_WRITE
;	o
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_22_S_WRITE:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	write_6_command,a2	;Write(6)R}h
    .else
	lea.l	write_6_command(pc),a2	;Write(6)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	write_6_command(pc),a2	;Write(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	d2,d6
	lea.l	-16(a5),aBUF
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	lea.l	-16(a5),aBUF
	move.l	d2,d6
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
	move.b	dLEN,4(aBUF)		;ubN
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	lsl.l	#8,dLEN
  .if SCSI_BIOS_LEVEL<=10
	lsl.l	d5,dLEN
  .else
;ubNw4ȏ̂Ƃ3ƌȂ
	moveq.l	#3,d0
	if	<cmp.l d0,d5>,lo
		move.l	d5,d0
	endif
	lsl.l	d0,dLEN
  .endif
	movea.l	a3,aBUF
  .if SCSI_BIOS_LEVEL<=4
	bsr	scsi_05_S_DATAOUT	;SCSIR[$05 _S_DATAOUT
  .else
	lea.l	scsi_05_S_DATAOUT(pc),a0	;SCSIR[$05 _S_DATAOUT
	if	<btst.b #SRAM_SCSI_SOFT_BIT,SRAM_SCSI_MODE>,ne	;\tg
		lea.l	scsi_0C_S_DATAOUTI(pc),a0	;SCSIR[$0C _S_DATAOUTI
	endif
	jsr	(a0)
  .endif
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
    .if 3<=SCSI_BIOS_LEVEL
	goto	<cmpi.l #-2,d0>,eq,writeext_error_2
    .endif
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_2	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Read(10)R}h
read_10_command:
	.dc.b	$28			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|FUA|Reserved##|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$26 _S_READEXT
;	gǂݍ
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_26_S_READEXT:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
  .if 10<=SCSI_BIOS_LEVEL
	goto	<tst.w dLEN>,eq,writeext_error_1
  .endif
	movea.l	aBUF,a3
;R}h
	lea.l	-16(a5),aBUF
  .if SCSI_BIOS_LEVEL<=0
	lea.l	read_10_command,a2	;Read(10)R}h
  .else
	lea.l	read_10_command(pc),a2	;Read(10)R}h
  .endif
	moveq.l	#10-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	dLEN,d6
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	move.l	dLEN,d6
  .endif
	move.l	d2,2(aBUF)		;ubNԍ
	move.b	dLEN,8(aBUF)		;ubN()
	lsr.l	#8,dLEN
	move.b	dLEN,7(aBUF)		;ubN()
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^CtF[Y
	move.l	d6,dLEN
	lsl.l	#8,dLEN
  .if SCSI_BIOS_LEVEL<=10
	lsl.l	d5,dLEN
  .else
;ubNw4ȏ̂Ƃ3ƌȂ
	moveq.l	#3,d0
	if	<cmp.l d0,d5>,lo
		move.l	d5,d0
	endif
	lsl.l	d0,dLEN
  .endif
	movea.l	a3,aBUF
  .if SCSI_BIOS_LEVEL<=4
	bsr	scsi_04_S_DATAIN	;SCSIR[$04 _S_DATAIN
  .else
	lea.l	scsi_04_S_DATAIN(pc),a0	;SCSIR[$04 _S_DATAIN
	if	<btst.b #SRAM_SCSI_SOFT_BIT,SRAM_SCSI_MODE>,ne	;\tg
		lea.l	scsi_0B_S_DATAINI(pc),a0	;SCSIR[$0B _S_DATAINI
	endif
	jsr	(a0)
  .endif
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
    .if 3<=SCSI_BIOS_LEVEL
	goto	<cmpi.l #-2,d0>,eq,writeext_error_2
    .endif
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_2	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Write(10)R}h
write_10_command:
	.dc.b	$2A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|FUA|Reserved##|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$27 _S_WRITEEXT
;	go
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_27_S_WRITEEXT:
	link.w	a5,#-16
	push	d1/dLEN/d6/aBUF/a2/a3
  .if 10<=SCSI_BIOS_LEVEL
	goto	<tst.w dLEN>,eq,writeext_error_1
  .endif
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	write_10_command,a2	;Write(10)R}h
    .else
	lea.l	write_10_command(pc),a2	;Write(10)R}h
    .endif
;_S_WRITEEXTA_S_VERIFYEXT
writeext_verifyext_common:
	movea.l	aBUF,a3
  .else
	movea.l	aBUF,a3
  .endif
;R}h
	lea.l	-16(a5),aBUF
  .if 10<=SCSI_BIOS_LEVEL
	lea.l	write_10_command(pc),a2	;Write(10)R}h
  .endif
	moveq.l	#10-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if 10<=SCSI_BIOS_LEVEL
	lea.l	-16(a5),aBUF
;_S_WRITEEXTA_S_VERIFYEXT
writeext_verifyext_common:
  .endif
	move.l	dLEN,d6
  .if SCSI_BIOS_LEVEL<=4
	lea.l	-16(a5),aBUF
  .endif
	move.l	d2,2(aBUF)		;ubNԍ
	move.b	dLEN,8(aBUF)		;ubN()
	lsr.l	#8,dLEN
	move.b	dLEN,7(aBUF)		;ubN()
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	move.l	d6,dLEN
	lsl.l	#8,dLEN
  .if SCSI_BIOS_LEVEL<=10
	lsl.l	d5,dLEN
  .else
;ubNw4ȏ̂Ƃ3ƌȂ
	moveq.l	#3,d0
	if	<cmp.l d0,d5>,lo
		move.l	d5,d0
	endif
	lsl.l	d0,dLEN
  .endif
	movea.l	a3,aBUF
  .if SCSI_BIOS_LEVEL<=4
	bsr	scsi_05_S_DATAOUT	;SCSIR[$05 _S_DATAOUT
  .else
	lea.l	scsi_05_S_DATAOUT(pc),a0	;SCSIR[$05 _S_DATAOUT
	if	<btst.b #SRAM_SCSI_SOFT_BIT,SRAM_SCSI_MODE>,ne	;\tg
		lea.l	scsi_0C_S_DATAOUTI(pc),a0	;SCSIR[$0C _S_DATAOUTI
	endif
	jsr	(a0)
  .endif
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
    .if 3<=SCSI_BIOS_LEVEL
	goto	<cmpi.l #-2,d0>,eq,writeext_error_2
    .endif
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop_test
	unlk	a5
	rts
  .else
writeext_stsin_2:
	goto	<cmpi.l #-1,d0>,eq,writeext_error_1
	goto	<cmpi.l #-2,d0>,eq,writeext_error_2
	goto	writeext_stsin_0

;Xe[^XCtF[YƃbZ[WCtF[Y
writeext_stsin_x:
	goto	<tst.l d0>,ne,writeext_error_1
writeext_stsin_0:
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
writeext_end:
	pop_test
	unlk	a5
	rts

;Xe[^XCtF[YƃbZ[WCtF[Y
writeext_stsin_1:
	goto	<cmpi.l #-1,d0>,ne,writeext_stsin_0
writeext_error_1:
	moveq.l	#-1,d0
	goto	writeext_end
  .endif

  .if 3<=SCSI_BIOS_LEVEL
writeext_error_2:
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	if	<tst.l d0>,eq
		moveq.l	#-2,d0
	endif
	pop
	unlk	a5
	rts
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Verify(10)R}h
verify_10_command:
	.dc.b	$2F			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|Reserved##|BytChk|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$28 _S_VERIFYEXT
;	gxt@C
;<d2.l:ubNԍ
;<dLEN.l:ubN
;<dID.l:(LUN<<16)|SCSI-ID
;<d5.l:ubNwB0=256,1=512,2=1024,3=2048
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_28_S_VERIFYEXT:
	link.w	a5,#-16
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .if 10<=SCSI_BIOS_LEVEL
	goto	<tst.w dLEN>,eq,writeext_error_1
  .endif
  .if SCSI_BIOS_LEVEL<=0
	lea.l	verify_10_command,a2	;Verify(10)R}h
  .elif SCSI_BIOS_LEVEL<=4
	lea.l	verify_10_command(pc),a2	;Verify(10)R}h
  .else
	movea.l	aBUF,a3
;R}h
	lea.l	-16(a5),aBUF
	lea.l	verify_10_command(pc),a2	;Verify(10)R}h
	moveq.l	#10-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
  .endif
;_S_WRITEEXTA_S_VERIFYEXT
	goto	writeext_verifyext_common

;----------------------------------------------------------------
;Format UnitR}h
format_unit_command:
	.dc.b	$04			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|FmtData|CmpLst|fBtFNgXg`###
	.dc.b	$00			;2 x_ŗL
	.dc.b	$00			;3 C^[u()
	.dc.b	$00			;4 C^[u()
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;SCSIR[$23 _S_FORMAT
;	tH[}bg
;<dLEN.l:C^[u
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_23_S_FORMAT:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	format_unit_command,a2	;Format UnitR}h
    .else
	lea.l	format_unit_command(pc),a2	;Format UnitR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	format_unit_command(pc),a2	;Format UnitR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.b	dLEN,4(aBUF)		;C^[u()
	lsr.l	#8,dLEN
	move.b	dLEN,3(aBUF)		;C^[u()
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Prevent-Allow Medium RemovalR}h
prevent_allow_command:
	.dc.b	$1E			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved#######|Prevent
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$32 _S_PAMEDIUM
;	CWFNg^CWFNg֎~
;<dLEN.l:0=CWFNg,1=CWFNg֎~
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_32_S_PAMEDIUM:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	prevent_allow_command,a2	;Prevent-Allow Medium RemovalR}h
    .else
	lea.l	prevent_allow_command(pc),a2	;Prevent-Allow Medium RemovalR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	prevent_allow_command(pc),a2	;Prevent-Allow Medium RemovalR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	andi.b	#1,dLEN
	move.b	dLEN,4(aBUF)		;0=CWFNg,1=CWFNg֎~
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Start-Stop Unit(Eject SONY MO)R}h
start_stop_unit_command:
	.dc.b	$1B			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|Immed
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved######|LoEj|Start
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2F _S_STARTSTOP
;	싖^֎~
;<dLEN.l:0=֎~,1=싖,2=A[h,3=[h
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2F_S_STARTSTOP:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	start_stop_unit_command,a2	;Start-Stop Unit(Eject SONY MO)R}h
    .else
	lea.l	start_stop_unit_command(pc),a2	;Start-Stop Unit(Eject SONY MO)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	start_stop_unit_command(pc),a2	;Start-Stop UnitR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	andi.b	#3,dLEN
	move.b	dLEN,4(aBUF)		;0=֎~,1=싖,2=A[h,3=[h
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Load/Unload SHARP MOR}h
load_unload_command:
	.dc.b	$C1			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|#####
	.dc.b	$00			;2
	.dc.b	$00			;3
	.dc.b	$00			;4 #######|LoEj
	.dc.b	$00			;5
  .endif

;----------------------------------------------------------------
;SCSIR[$30 _S_SEJECT
;	CWFNg(SHARP MO)
;	SUSIE.Xł_S_EJECT6MO1ƌĂ΂Ă
;<dLEN.l:0=A[h,1=[h
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_30_S_SEJECT:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	load_unload_command,a2	;Load/Unload SHARP MOR}h
    .else
	lea.l	load_unload_command(pc),a2	;Load/Unload SHARP MOR}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	load_unload_command(pc),a2	;Load/Unload SHARP MOR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	andi.b	#1,dLEN
	move.b	dLEN,4(aBUF)		;0=A[h,1=[h
;ZNVtF[YƃR}hAEgtF[Y
	moveq.l	#6,dLEN			;
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Seek(6)R}h
seek_6_command:
	.dc.b	$0B			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|ubNԍ()#####
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$2D _S_SEEK
;	V[N
;<d2.l:ubNԍ
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_2D_S_SEEK:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	seek_6_command,a2	;Seek(6)R}h
    .else
	lea.l	seek_6_command(pc),a2	;Seek(6)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	seek_6_command(pc),a2	;Seek(6)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	d2,d6
	lea.l	-16(a5),aBUF
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	lea.l	-16(a5),aBUF
	move.l	d2,d6
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=3
;+++++ BUG +++++
;Reserved̃tB[hɏł
	move.b	dLEN,4(aBUF)
;+++++ BUG +++++
  .endif
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Assign Drive(SASI)R}h
assign_drive_sasi_command:
	.dc.b	$C2			;0 Iy[VR[h
	.dc.b	$00			;1
	.dc.b	$00			;2
	.dc.b	$00			;3
	.dc.b	$00			;4
	.dc.b	$00			;5 f[^̒
  .endif

;----------------------------------------------------------------
;SCSIR[$36 _S_DSKINI
;	Assign Drive(SASI)
;<dLEN.l:f[^̒
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_36_S_DSKINI:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	assign_drive_sasi_command,a2	;Assign Drive(SASI)R}h
    .else
	lea.l	assign_drive_sasi_command(pc),a2	;Assign Drive(SASI)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	assign_drive_sasi_command(pc),a2	;Assign Drive(SASI)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
  .if SCSI_BIOS_LEVEL<=4
	move.l	dLEN,d1
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	move.l	dLEN,d1
  .endif
	move.b	d1,5(aBUF)		;f[^̒
;ZNVtF[YƃR}hAEgtF[Y
	moveq.l	#6,dLEN
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	move.l	d1,dLEN
	movea.l	a3,aBUF
	bsr	scsi_0C_S_DATAOUTI	;SCSIR[$0C _S_DATAOUTI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Format Block(SASI)R}h
format_block_sasi_command:
	.dc.b	$06			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5
  .endif

;----------------------------------------------------------------
;SCSIR[$37 _S_FORMATB
;	Format Block(SASI)
;<d2.l:ubNԍ
;<dLEN.l:C^[u
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_37_S_FORMATB:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	format_block_sasi_command,a2	;Format Block(SASI)R}h
    .else
	lea.l	format_block_sasi_command(pc),a2	;Format Block(SASI)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	format_block_sasi_command(pc),a2	;Format BlockR}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.l	d2,d6
  .if SCSI_BIOS_LEVEL<=4
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
	move.b	dLEN,4(aBUF)		;C^[u
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Bad Track Format(SASI)R}h
bad_track_format_sasi_command:
	.dc.b	$07			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5 Rg[oCg
  .endif

;----------------------------------------------------------------
;SCSIR[$38 _S_BADFMT
;	Bad Track Format(SASI)
;<d2.l:ubNԍ
;<dLEN.l:C^[u
;<dID.l:(LUN<<16)|SCSI-ID
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_38_S_BADFMT:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	bad_track_format_sasi_command,a2	;Bad Track Format(SASI)R}h
    .else
	lea.l	bad_track_format_sasi_command(pc),a2	;Bad Track Format(SASI)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	bad_track_format_sasi_command(pc),a2	;Bad Track Format(SASI)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.l	d2,d6
  .if SCSI_BIOS_LEVEL<=4
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
	move.b	dLEN,4(aBUF)		;C^[u
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_x
  .endif

  .if 3<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;Assign Track(SASI)R}h
assign_track_sasi_command:
	.dc.b	$0E			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5
  .endif

;----------------------------------------------------------------
;SCSIR[$39 _S_ASSIGN
;	Assign Track(SASI)
;<d2.l:ubNԍ
;<dLEN.l:C^[u
;<dID.l:(LUN<<16)|SCSI-ID
;<aBUF.l:obt@̃AhX
;>d0.l:0=,-1=s,̑=(MSGIN<<16)|STSIN
scsi_39_S_ASSIGN:
	link.w	a5,#-16
  .if SCSI_BIOS_LEVEL<=4
	push	d1/dLEN/d6/aBUF/a2/a3
  .else
	movem.l	d1/dLEN/d6/aBUF/a2/a3,-(sp)
  .endif
	movea.l	aBUF,a3
;R}h
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	assign_track_sasi_command,a2	;Assign Track(SASI)R}h
    .else
	lea.l	assign_track_sasi_command(pc),a2	;Assign Track(SASI)R}h
    .endif
	lea.l	-16(a5),aBUF
  .else
	lea.l	-16(a5),aBUF
	lea.l	assign_track_sasi_command(pc),a2	;Assign Track(SASI)R}h
  .endif
	moveq.l	#6-1,d1
	for	d1
		move.b	(a2)+,(aBUF)+
	next
	lea.l	-16(a5),aBUF
	move.l	d2,d6
  .if SCSI_BIOS_LEVEL<=4
	move.b	d6,3(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,2(aBUF)		;ubNԍ()
	lsr.l	#8,d6
	move.b	d6,1(aBUF)		;ubNԍ()
  .else
	and.l	#$00FFFFFF,d6
	or.l	d6,(aBUF)		;ubNԍ
  .endif
	move.b	dLEN,4(aBUF)		;C^[u
;ZNVtF[YƃR}hAEgtF[Y
	bsr	select_and_cmdout	;ZNVtF[YƃR}hAEgtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<tst.l d0>,ne,assign_error
  .else
	goto	<tst.l d0>,ne,writeext_error_1
  .endif
;f[^AEgtF[Y
	moveq.l	#4,dLEN			;
	movea.l	a3,aBUF
	bsr	scsi_0C_S_DATAOUTI	;SCSIR[$0C _S_DATAOUTI
;Xe[^XCtF[YƃbZ[WCtF[Y
  .if SCSI_BIOS_LEVEL<=4
	goto	<cmpi.l #-1,d0>,eq,assign_error
	bsr	stsin_and_msgin		;Xe[^XCtF[YƃbZ[WCtF[Y
	pop_test
	unlk	a5
	rts

assign_error:
	moveq.l	#-1,d0
	pop
	unlk	a5
	rts
  .else
	goto	writeext_stsin_1	;Xe[^XCtF[YƃbZ[WCtF[Y
  .endif


  .if SCSI_BIOS_LEVEL<=3


;----------------------------------------------------------------
;SCSIo(DMA])
;	MC68040܂MC68060̂Ƃ̓f[^LbVvbVĂĂяoKv
;<dLEN.l:
;<aBUF.l:AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
dataout_transfer:
	push	dLEN/aBUF
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;REQ=1҂
	do
		move.b	SPC_PSNS(aSPC),d0
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)	;]Jn
	bsr	dataout_dma		;SCSIo(DMA])s
	goto	<tst.l d0>,ne,dataout_transfer_end	;]sBI
;荞݂҂
	do
		move.b	SPC_INTS(aSPC),d0
	while	eq
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	goto	<cmp.b #SPC_INTS_CC,d0>,eq,dataout_transfer_no_error
dataout_transfer_end:
	pop_test
	rts

dataout_transfer_no_error:
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])
;<dLEN.l:
;<aBUF.l:AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
datain_transfer:
	push	dLEN/aBUF
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
;]Jn
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
	bsr	datain_dma		;SCSI(DMA])s
	goto	<tst.l d0>,ne,datain_transfer_end
;荞݂҂
datain_transfer_wait:
	do
		move.b	SPC_INTS(aSPC),d0
	while	eq
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	goto	<cmp.b #SPC_INTS_CC,d0>,eq,datain_transfer_no_error
datain_transfer_end:
	pop_test
	rts

datain_transfer_no_error:
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;SCSIo(DMA])s
;<dLEN.l:
;<aBUF.l:AhX
dataout_dma:
aDMAC	reg	a0
	push	aDMAC/a3
;DMAݒ肷
	lea.l	DMAC_1_BASE,aDMAC
	move.b	#$FF,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
	move.b	#DMAC_MEMORY_TO_DEVICE|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX,DMAC_OCR(aDMAC)
	move.w	#0,DMAC_BTC(aDMAC)
	move.b	#DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT,DMAC_DCR(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	lea.l	SPC_DREG(aSPC),a3
	move.l	a3,DMAC_DAR(aDMAC)
;256oCg]
	do
	;<dLEN.l:̎c̃f[^̒
	;<aBUF.l:̃obt@̃AhX
		goto	<cmp.l #256,dLEN>,ls,dataout_dma_last	;c1`256oCg
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	#256,DMAC_MTC(aDMAC)	;f[^̒
	dataout_dma_continue:
	;FIFOɂȂ܂ő҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,eq
	;REQ=1҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
	;DMA]Jn
		move.b	#-1,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		nop
		nop
		nop
    .if 3<=SCSI_BIOS_LEVEL
		nop
    .endif
	;DMA]I҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(aDMAC)>,eq
	;+++++ BUG +++++
	;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
	;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
		goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,dataout_dma_continue
	;+++++ BUG +++++
		goto	<tst.b DMAC_CER(aDMAC)>,ne,dataout_dma_error	;DMAG[
		adda.l	#256,aBUF		;̃obt@̃AhX
		sub.l	#256,dLEN		;̎c̃f[^̒
	while	ne
	moveq.l	#0,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop_test
	rts

;c1`256oCg
dataout_dma_last:
	move.l	aBUF,DMAC_MAR(aDMAC)
	move.w	dLEN,DMAC_MTC(aDMAC)
dataout_dma_last_start:
;FIFOɂȂ܂ő҂
	do
		goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
	while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,eq
;REQ=1҂
	do
		goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
		move.b	SPC_PSNS(aSPC),d0
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
;DMA]Jn
	move.b	#-1,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
	move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
	nop
	nop
	nop
    .if 3<=SCSI_BIOS_LEVEL
	nop
    .endif
;DMA]I҂
	do
		goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
	while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(aDMAC)>,eq
;+++++ BUG +++++
;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
    .if SCSI_BIOS_LEVEL<=0
	goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,dataout_dma_continue
    .else
	goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,dataout_dma_last_start
    .endif
;+++++ BUG +++++
	goto	<tst.b DMAC_CER(aDMAC)>,ne,dataout_dma_error	;DMAG[
	moveq.l	#0,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop_test
	rts

;DMAG[
dataout_dma_error:
	moveq.l	#-1,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])s
;<dLEN.l:
;<aBUF.l:AhX
;<a6.l:SPCx[XAhX
datain_dma:
aDMAC	reg	a0
	push	aDMAC/a3
;DMAݒ肷
	lea.l	DMAC_1_BASE,aDMAC
	move.b	#$FF,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
	move.b	#DMAC_DEVICE_TO_MEMORY|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX,DMAC_OCR(aDMAC)
	move.w	#0,DMAC_BTC(aDMAC)
	move.b	#DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT,DMAC_DCR(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	lea.l	SPC_DREG(aSPC),a3
	move.l	a3,DMAC_DAR(aDMAC)
;256oCg]
	do
	;<dLEN.l:̎c̃f[^̒
	;<aBUF.l:̃obt@̃AhX
		goto	<cmp.l #256,dLEN>,ls,datain_dma_last	;c1`256oCg
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	#256,DMAC_MTC(aDMAC)	;f[^̒
	datain_dma_continue:
	;FIFOłȂȂ܂ő҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
	;DMA]Jn
		move.b	#$FF,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		nop
		nop
		nop
    .if 3<=SCSI_BIOS_LEVEL
		nop
    .endif
	;DMA]I҂
		do
			goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(aDMAC)>,eq
	;+++++ BUG +++++
	;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
	;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
		goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,datain_dma_continue
	;+++++ BUG +++++
		goto	<tst.b DMAC_CER(aDMAC)>,ne,datain_dma_error	;DMAG[
		adda.l	#256,aBUF		;̃obt@̃AhX
		sub.l	#256,dLEN		;̎c̃f[^̒
	while	ne
	moveq.l	#0,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop_test
	rts

;c1`256oCg
datain_dma_last:
	move.l	aBUF,DMAC_MAR(aDMAC)
	move.w	dLEN,DMAC_MTC(aDMAC)
datain_dma_last_start:
;FIFOłȂȂ܂ő҂
	do
		goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
	while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
;DMA]Jn
	move.b	#$FF,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
	move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
	nop
	nop
	nop
    .if 3<=SCSI_BIOS_LEVEL
	nop
    .endif
;DMA]I҂
	do
		goto	<tst.b SPC_INTS(aSPC)>,ne,dataio_interrupted	;SPC荞݂
	while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(aDMAC)>,eq
;+++++ BUG +++++
;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
	goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,datain_dma_last_start
;+++++ BUG +++++
	goto	<tst.b DMAC_CER(aDMAC)>,ne,datain_dma_error	;DMAG[
	moveq.l	#0,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop_test
	rts

;DMAG[
datain_dma_error:
	moveq.l	#-1,d0
    .if 3<=SCSI_BIOS_LEVEL
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
    .endif
	pop_test
	rts

;SPC荞݂
dataio_interrupted:
    .if SCSI_BIOS_LEVEL<=0
	move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA쒆~
	moveq.l	#0,d0
	pop
	rts
    .else
	move.b	SPC_INTS(aSPC),d0
	goto	<cmpi.b #SPC_INTS_CC,d0>,ne,dataio_abort	;SPC]IĂȂ
;SPC]I
	goto	<tst.w DMAC_MTC(aDMAC)>,ne,dataio_abort_2	;DMA]IĂȂ
	moveq.l	#0,d0
	goto	dataio_abort

;DMA]IĂȂ
dataio_abort_2:
	moveq.l	#-2,d0
;SPC]IĂȂ
dataio_abort:
	move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA쒆~
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
	pop
	rts
    .endif


  .elif SCSI_BIOS_LEVEL<=4


;----------------------------------------------------------------
;SCSIo(DMA])
;	MC68040܂MC68060̂Ƃ̓f[^LbVvbVĂĂяoKv
;<dLEN.l:
;<aBUF.l:AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
dataout_transfer:
	move.l	a3,-(sp)
	lea.l	dataout_dma(pc),a3	;SCSIo(DMA])s
	bsr	dataio_transfer		;SCSIo(DMA])
	movea.l	(sp)+,a3
	rts

;----------------------------------------------------------------
;SCSI(DMA])
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
datain_transfer:
	move.l	a3,-(sp)
	lea.l	datain_dma(pc),a3	;SCSI(DMA])s
	bsr	dataio_transfer		;SCSIo(DMA])
;LbVNA
;!!! @킪X68030̂Ƃ]CACR𒼐ڑ삵ăf[^LbVNAĂ
	push	d0/d1
	move.b	SYSPORT_MODEL,d0
	lsr.b	#4,d0
	if	<cmpi.b #14,d0>,cs	;X68030
		.cpu	68030
		movec.l	cacr,d0
		move.l	d0,d1
		bset.l	#11,d0			;f[^LbVNA
		movec.l	d0,cacr
		movec.l	d1,cacr
		.cpu	68000
	endif
	pop
	movea.l	(sp)+,a3
	rts

;----------------------------------------------------------------
;SCSIo(DMA])
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;<a3.l:dataout_dma܂datain_dma
;<a6.l:SPCx[XAhX
dataio_transfer:
aDMAC	reg	a2
	push	aBUF/aDMAC
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PSNS_MSG|SPC_PSNS_CD|SPC_PSNS_IO,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)	;f[^̒()
;REQ=1҂
	do
		move.b	SPC_PSNS(aSPC),d0
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
;DMAݒ肷
	lea.l	DMAC_1_BASE,aDMAC
;<a2.l:DMA`lx[XAhX
	move.b	#$FF,DMAC_CSR.w(aDMAC)	;DMAC_CSRNA
	move.w	#0,DMAC_BTC(aDMAC)
	move.b	#DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT,DMAC_DCR(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	lea.l	SPC_DREG(aSPC),a0
	move.l	a0,DMAC_DAR(aDMAC)
;REQ=1҂
	do
		move.b	SPC_PSNS(aSPC),d0
	while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
;]Jn
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)	;]Jn
	jsr	(a3)			;dataout_dma܂datain_dma
	goto	<tst.l d0>,ne,dataio_transfer_end	;]sBI
;]I҂
	do
		goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,dataio_transfer_phase	;tF[Ysv
	while	<btst.b #SPC_INTS_CC_BIT,SPC_INTS(aSPC)>,eq
;]I
	bset.b	#SPC_INTS_CC_BIT,SPC_INTS(aSPC)	;Command CompleteNA
	moveq.l	#0,d0
	goto	dataio_transfer_end

;tF[Ysv
dataio_transfer_phase:
	bset.b	#SPC_INTS_SR_BIT,SPC_INTS(aSPC)	;Service RequiredNA
	moveq.l	#-3,d0
	goto	dataio_transfer_end

;+++++ BUG +++++
;ǂQƂĂȂ
	moveq.l	#-1,d0
;+++++ BUG +++++
;I
dataio_transfer_end:
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
	pop
	rts

;----------------------------------------------------------------
;SCSIo(DMA])s
;<dLEN.l:
;<aBUF.l:AhX
;<a2.l:DMA`lx[XAhX
;<a6.l:SPCx[XAhX
dataout_dma:
	push	d1/d2/dLEN/d4/d5/aBUF
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
	move.b	#DMAC_MEMORY_TO_DEVICE|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX,DMAC_OCR(aDMAC)
	move.l	dLEN,d4
;256oCg]
	do
		if	<cmp.l #256,dLEN>,hi
			move.l	#256,d5
		else
			move.l	dLEN,d5
		endif
	;<dLEN.l:c̃f[^̒
	;<d4.l:c̃f[^̒
	;<d5.l:]钷
	;<aBUF.l:obt@̃AhX
		move.l	aBUF,DMAC_MAR(a2)	;obt@̃AhX
		move.w	d5,DMAC_MTC(a2)		;]钷
	dataout_dma_continue:
	;FIFOɂȂ܂ő҂
		do
			goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,dataout_dma_phase	;tF[Ysv
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,eq
	;REQ=1҂
		do
			goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,dataout_dma_phase	;tF[Ysv
			move.b	SPC_PSNS(aSPC),d0
		while	<btst.l #SPC_PSNS_REQ_BIT,d0>,eq
	;oXG[΍
	;	X68000łDMACSPCDREQO]vMƂĎgȂ߁A
	;	DREQoĂȂƂDTACKoȂƂDREGւ̃Cg҂Ă
	;	SCSI@̃f[^̎󂯎肪xƃobt@tɂȂDREQoȂȂ
	;	DREGւ̃CgDTACKoȂƃoXG[ē]f
	;	̂ƂDMAC̓oXG[ɂȂf[^͓]ȂƔf邪A
	;	SPC̓oXG[mĂȂ̂ŁABERRAT[gĂASlQ[g܂ł̊Ԃ
	;	oXG[ɂȂ͂̃f[^󂯎Ă܂ꍇ
	;	oăf[^dȂ悤ɂ
		moveq.l	#0,d0
		move.b	SPC_TCH(aSPC),d0
		lsl.l	#8,d0
		move.b	SPC_TCM(aSPC),d0
		lsl.l	#8,d0
		move.b	SPC_TCL(aSPC),d0	;SPC]c̒
		move.l	d4,d1			;ubNJn̎c̒
		sub.l	d0,d1			;SPC̃ubNœ]
		moveq.l	#0,d0
		move.w	DMAC_MTC(a2),d0		;DMAC̍̃ubN̎c̒
		move.l	d5,d2			;]钷
		sub.l	d0,d2			;DMAC̃ubNœ]
		sub.l	d2,d1			;SPCDMAC]
		if	ne
			add.l	d1,DMAC_MAR(a2)		;DMAC]AhXi߂
			sub.w	d1,DMAC_MTC(a2)		;DMAC]钷炷
		endif
	;]Jn
		move.b	#-1,DMAC_CSR(a2)		;DMAC_CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(a2)	;]Jn
		nop
		nop
		nop
		nop
		nop
	;]I҂
		do
			goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,dataout_dma_phase	;tF[Ysv
			break	<btst.b #SPC_INTS_CC_BIT,SPC_INTS(aSPC)>,ne	;]I
		while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(a2)>,eq
	;SPC܂DMA]I
	;+++++ BUG +++++
	;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
	;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
		goto	<btst.b #1,DMAC_CER(a2)>,ne,dataout_dma_continue
	;+++++ BUG +++++
		goto	<tst.b DMAC_CER(a2)>,ne,dataout_dma_error	;DMAG[
		goto	<tst.w DMAC_MTC(a2)>,ne,dataout_dma_error	;DMA]IĂȂ
		adda.l	d5,aBUF			;AhX𑝂₷
		sub.l	d5,d4			;炷
		sub.l	d5,dLEN			;炷
	while	ne
	moveq.l	#0,d0
	goto	dataout_dma_end		;I

;tF[Ysv
dataout_dma_phase:
	moveq.l	#-3,d0
	goto	dataout_dma_abort	;]~

;DMAG[
;DMA]IĂȂ
dataout_dma_error:
	moveq.l	#-2,d0
	goto	dataout_dma_abort	;]~

;+++++ BUG +++++
;ǂQƂĂȂ
	moveq.l	#-1,d0
;+++++ BUG +++++
;]~
dataout_dma_abort:
	move.b	#DMAC_CCR_SAB,DMAC_CCR(a2)	;DMA]~
;I
dataout_dma_end:
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])s
;<dLEN.l:
;<aBUF.l:AhX
;<a2.l:DMA`lx[XAhX
;<a6.l:SPCx[XAhX
datain_dma:
	push	d1/d2/dLEN/d4/d5/aBUF
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
	move.b	#DMAC_DEVICE_TO_MEMORY|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX,DMAC_OCR(aDMAC)
;256oCg]
	do
		if	<cmp.l #256,dLEN>,hi
			move.l	#256,d5
		else
			move.l	dLEN,d5
		endif
	;<dLEN.l:c̃f[^̒
	;<d5.l:]钷
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	d5,DMAC_MTC(aDMAC)	;]钷
	datain_dma_continue:
	;FIFOłȂȂ܂ő҂
		do
			goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,datain_dma_phase	;tF[Ysv
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
	;]Jn
		move.b	#-1,DMAC_CSR(aDMAC)	;DMAC_CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;]Jn
		nop
		nop
		nop
		nop
		nop
	;]I҂
		do
			goto	<btst.b #SPC_INTS_SR_BIT,SPC_INTS(aSPC)>,ne,datain_dma_phase	;tF[Ysv
			break	<btst.b #SPC_INTS_CC_BIT,SPC_INTS(aSPC)>,ne	;]I
		while	<btst.b #DMAC_CSR_COC_BIT,DMAC_CSR(aDMAC)>,eq
	;SPC܂DMA]I
	;+++++ BUG +++++
	;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
	;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
		goto	<btst.b #1,DMAC_CER(aDMAC)>,ne,datain_dma_continue
	;+++++ BUG +++++
		goto	<tst.b DMAC_CER(aDMAC)>,ne,datain_dma_error	;DMAG[
		goto	<tst.w DMAC_MTC(aDMAC)>,ne,datain_dma_error	;DMA]IĂȂ
		adda.l	d5,aBUF			;AhX𑝂₷
		sub.l	d5,d4			;炷
		sub.l	d5,dLEN			;炷
	while	ne
	moveq.l	#0,d0
	goto	datain_dma_end		;I

;tF[Ysv
datain_dma_phase:
	moveq.l	#-3,d0
	goto	datain_dma_abort	;]~

;DMAG[
;DMA]IĂȂ
datain_dma_error:
	moveq.l	#-2,d0
	goto	datain_dma_abort	;]~

;+++++ BUG +++++
;ǂQƂĂȂ
	moveq.l	#-1,d0
;+++++ BUG +++++
;]~
datain_dma_abort:
	move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA]~
;I
datain_dma_end:
	pop
	rts


  .elif SCSI_BIOS_LEVEL<=10


;----------------------------------------------------------------
;SCSIo(DMA])
;	MC68040܂MC68060̂Ƃ̓f[^LbVvbVĂĂяoKv
;<dLEN.l:
;<aBUF.l:AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
dataout_transfer:
	push	dLEN/aBUF
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;Zbg
	move.l	#$00FFFFFF,d0
	and.l	dLEN,d0
	movep.l	d0,SPC_TEMP(aSPC)
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;REQ=1҂
	do
	while	<tst.b SPC_PSNS(aSPC)>,pl	;SPC_PSNS_REQ_BIT
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
	bsr	dataout_dma		;SCSIo(DMA])s
	if	<tst.l d0>,eq
	;荞݂҂
		do
			move.b	SPC_INTS(aSPC),d0
		while	eq
		move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
		if	<cmp.b #SPC_INTS_CC,d0>,eq
			moveq.l	#0,d0
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
datain_transfer:
	push	dLEN/aBUF
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;Zbg
	move.l	#$00FFFFFF,d0
	and.l	dLEN,d0
	movep.l	d0,SPC_TEMP(aSPC)
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
	bsr	datain_dma		;SCSI(DMA])s
	if	<tst.l d0>,eq
	;荞݂҂
		do
			move.b	SPC_INTS(aSPC),d0
		while	eq
		move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
		if	<cmp.b #SPC_INTS_CC,d0>,eq
			moveq.l	#0,d0
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])s
datain_dma:
	push	d1/d2/a0/a3
~dcr = DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
~ocr = DMAC_DEVICE_TO_MEMORY|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX
	move.w	#(~dcr<<8)|~ocr,d1
	goto	dataio_dma_common	;SCSIo(DMA])s

;----------------------------------------------------------------
;SCSIo(DMA])s
dataout_dma:
	push_again
~dcr = DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
~ocr = DMAC_MEMORY_TO_DEVICE|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX
	move.w	#(~dcr<<8)|~ocr,d1
;----------------------------------------------------------------
;SCSIo(DMA])s
dataio_dma_common:
	bsr	cache_flush		;DMA]JnÕLbVtbV
aDMAC	reg	a0
;DMAݒ肷
	lea.l	DMAC_1_BASE,aDMAC
	st.b	DMAC_CSR(aDMAC)		;DMAC_CSRNA
	clr.w	DMAC_BTC(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	lea.l	SPC_DREG(aSPC),a3
	move.l	a3,DMAC_DAR(aDMAC)
;xɓ]钷߂
	moveq.l	#0,d2
	move.w	#256,d2
	if	<tst.b SRAM_SCSI_MODE>,mi	;SRAM_SCSI_BLOCK_BIT ubN
		moveq.l	#0,d2
		move.w	BIOS_SCSI_BLOCK_SIZE.l,d2	;SCSI@̃ubNTCY
	endif
;o[Xgɂ邩
	if	<btst.b #SRAM_SCSI_BURST_BIT,SRAM_SCSI_MODE>,ne	;o[Xg
	;O]vɂ
	;DMAREQ1SPCDREQɌqĂ̂X68030
~dcr = DMAC_NO_HOLD_CYCLE^DMAC_BURST_TRANSFER
~ocr = DMAC_AUTO_REQUEST_MAX^DMAC_EXTERNAL_REQUEST
		eori.w	#(~dcr<<8)|~ocr,d1
	endif
;DMAC_DCRDMAC_OCRݒ肷
	move.w	d1,DMAC_DCR(aDMAC)	;DMAC_DCRDMAC_OCR
;͂Əo͂ŕ򂷂
aINTS	reg	a3
	lea.l	SPC_INTS(aSPC),aINTS
	goto	<tst.b d1>,mi,dataio_dma_input	;pl=DMAC_MEMORY_TO_DEVICE,mi=DMAC_DEVICE_TO_MEMORY
						;
;o
dataio_dma_output:
	do
	;<dLEN.l:̎c̃f[^̒
	;<aBUF.l:̃obt@̃AhX
		goto	<cmp.l d2,dLEN>,ls,dataio_dma_output_last	;c1`ubNTCY
	dataio_dma_output_start:
	;<d2.l:]钷
	;̃obt@̃AhXƍ]钷DMAɐݒ肷
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	d2,DMAC_MTC(aDMAC)	;]钷
	dataio_dma_output_continue:
	;FIFOɂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,eq
	;REQ=1҂
		do
			goto	<tst.b (aINTS)>,ne,dataio_interrupted	;SPC荞݂
		while	<tst.b SPC_PSNS(aSPC)>,pl	;SPC_PSNS_REQ_BIT
	;DMA]Jn
		st.b	DMAC_CSR(aDMAC)		;CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		tst.b	(aINTS)			;ǂ݁H
	;DMA]I҂
		do
			goto	<tst.b (aINTS)>,ne,dataio_interrupted	;SPC荞݂
		while	<tst.b DMAC_CSR(aDMAC)>,pl	;DMAC_CSR_COC
	;G[ȂmF
		move.b	DMAC_CER(aDMAC),d0
		goto	ne,dataio_dma_output_error	;DMAG[
	;c̃f[^̒0ɂȂ܂ŌJԂ
		adda.l	d2,aBUF			;̃obt@̃AhX
		sub.l	d2,dLEN			;̎c̃f[^̒
	while	ne
	moveq.l	#0,d0
dataio_dma_output_end:
;+++++ BUG +++++
;DMAC_DARSASIɖ߂ĂȂ
;+++++ BUG +++++
	pop_test
	rts

;c1`ubNTCY
dataio_dma_output_last:
	move.l	dLEN,d2			;]钷͎c̃f[^̒
	goto	dataio_dma_output_start

;DMAG[
dataio_dma_output_error:
;+++++ BUG +++++
;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
	goto	<btst.l #1,d0>,ne,dataio_dma_output_continue
;+++++ BUG +++++
;oXG[ȊODMAG[
	moveq.l	#-1,d0
	goto	dataio_dma_output_end

;SPC荞݂
dataio_interrupted:
	move.b	SPC_INTS(aSPC),d0
	goto	<cmpi.b #SPC_INTS_CC,d0>,ne,dataio_dma_output_abort	;SPC]IĂȂB]~
;SPC]I
	moveq.l	#0,d0
	goto	<tst.w DMAC_MTC(aDMAC)>,eq,dataio_dma_output_abort	;DMA]IB]~
;SPC͓]IDMA]IĂȂ
	moveq.l	#-2,d0
;]~
dataio_dma_output_abort:
	move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA]~
	goto	dataio_dma_output_end

;c1`ubNTCY
dataio_dma_input_last:
	move.l	dLEN,d2			;]钷͎c̃f[^̒
	goto	dataio_dma_input_start

;
dataio_dma_input:
	do
	;<dLEN.l:̎c̃f[^̒
	;<aBUF.l:̃obt@̃AhX
		goto	<cmp.l d2,dLEN>,ls,dataio_dma_input_last	;c1`ubNTCY
	dataio_dma_input_start:
	;<d2.l:]钷
	;̃obt@̃AhXƍ]钷DMAɐݒ肷
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	d2,DMAC_MTC(aDMAC)	;]钷
	dataio_dma_input_continue:
	;FIFOłȂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataio_interrupted	;SPC荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
	;DMA]Jn
		st.b	DMAC_CSR(aDMAC)		;CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		tst.b	(aINTS)			;ǂ݁H
	;DMA]I҂
		do
			goto	<tst.b (aINTS)>,ne,dataio_interrupted	;SPC荞݂
		while	<tst.b DMAC_CSR(aDMAC)>,pl	;DMAC_CSR_COC
	;G[ȂmF
		move.b	DMAC_CER(aDMAC),d0
		goto	ne,dataio_dma_input_error	;DMAG[
	;c̃f[^̒0ɂȂ܂ŌJԂ
		adda.l	d2,aBUF			;̃obt@̃AhX
		sub.l	d2,dLEN			;̎c̃f[^̒
	while	ne
	moveq.l	#0,d0
dataio_dma_input_end:
;+++++ BUG +++++
;DMAC_DARSASIɖ߂ĂȂ
;+++++ BUG +++++
	pop
	rts

;DMAG[
dataio_dma_input_error:
;+++++ BUG +++++
;DMAC_CER5rbg̃G[R[h̃rbg1eXgăoXG[(foCXAhX)ƌȂĂ
;oXG[(foCXAhX)̃G[R[h$0Ãrbg1܂1̂œĂH
	goto	<btst.l #1,d0>,ne,dataio_dma_input_continue
;+++++ BUG +++++
;oXG[ȊODMAG[
	moveq.l	#-1,d0
	goto	dataio_dma_input_end


  .else


;----------------------------------------------------------------
;SCSIo(DMA])
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,-1=DMAG[,̑=INTS
dataout_transfer:
	push	d1/d2/dLEN/a0/aBUF/a3
aDMAC	reg	a0
aINTS	reg	a3
	lea.l	DMAC_1_BASE,aDMAC
	lea.l	SPC_INTS(aSPC),aINTS
;LbVtbV
	bsr	cache_flush
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)	;f[^̒()
;REQ=1҂
	do
	while	<tst.b SPC_PSNS(aSPC)>,pl	;SPC_PSNS_REQ_BIT
;SPC]Jn
	move.b	(aINTS),(aINTS)		;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
;DCROCR߂
;	X68000SPCDREQDMACREQ1ɌqĂȂ
;	DREQgDTACK̂ŃI[gNGXgő呬xp
~dcr = DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT
~ocr = DMAC_MEMORY_TO_DEVICE|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX
	move.w	#(~dcr<<8)|~ocr,d1
    .if SCSIEXROM==0
	ifand	<isX68030>,eq,<btst.b #SRAM_SCSI_BURST_BIT,SRAM_SCSI_MODE>,ne	;SCSIX68030o[Xg
~dcr = DMAC_NO_HOLD_CYCLE^DMAC_BURST_TRANSFER
~ocr = DMAC_AUTO_REQUEST_MAX^DMAC_EXTERNAL_REQUEST
		eori.w	#(~dcr<<8)|~ocr,d1
	endif
    .endif
;DMACݒ肷
	st.b	DMAC_CSR(aDMAC)		;CSRNA
	clr.w	DMAC_BTC(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	move.w	d1,DMAC_DCR(aDMAC)	;DMAC_DCR,DMAC_OCR
	moveq.l	#SPC_DREG,d0
	add.l	aSPC,d0
	move.l	d0,DMAC_DAR(aDMAC)	;DARDREGݒ
;ubN̒߂
	move.l	#256,d2
	if	<tst.b SRAM_SCSI_MODE>,mi	;SRAM_SCSI_BLOCK_BIT
		move.w	BIOS_SCSI_BLOCK_SIZE.l,d2	;SCSI@̃ubNTCY
	endif
;<d2.l:ubN̒
	do
	;<dLEN.l:ubNJn̑Ŝ̎c̒
	;<aBUF.l:ubNJñf[^̃AhX
	;Ō̃ubN̒𒲐
		if	<cmp.l dLEN,d2>,hi
			move.l	dLEN,d2
		endif
	;<d2.l:ubN̒
	dataout_transfer_continue:
	;FIFOɂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,dataout_transfer_finish	;SPCI
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,eq
	;f[^̃AhXƃubN̎c̒vZ
		moveq.l	#0,d0
		move.b	SPC_TCH(aSPC),d0	;f[^̒()
		swap.w	d0
		move.b	SPC_TCM(aSPC),d0	;f[^̒()
		lsl.w	#8,d0
		move.b	SPC_TCL(aSPC),d0	;f[^̒()
	;<d0.l:Ŝ̎c̒
		sub.l	dLEN,d0			;-(ubN̓])=(Ŝ̎c̒)-(ubNJn̑Ŝ̎c̒)
	;<d0.l:-(ubN̓])
		move.l	aBUF,d1
		sub.l	d0,d1			;(f[^̃AhX)=(ubNJñf[^̃AhX)+(ubN̓])
	;<d1.l:f[^̃AhX
		add.l	d2,d0			;(ubN̎c̒)=(ubN̒)-(ubN̓])
	;<d0.l:ubN̎c̒
		st.b	DMAC_CSR(aDMAC)		;CSRNA
		move.l	d1,DMAC_MAR(aDMAC)	;f[^̃AhX
		move.w	d0,DMAC_MTC(aDMAC)	;ubN̎c̒
	;REQ=1҂
		do
			goto	<tst.b (aINTS)>,ne,dataout_transfer_finish	;SPCI
		while	<tst.b SPC_PSNS(aSPC)>,pl	;SPC_PSNS_REQ_BIT
	;DMA]Jn
		st.b	DMAC_CSR(aDMAC)		;CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		tst.b	(aINTS)			;ǂ
	;DMAI҂
		do
			goto	<tst.b (aINTS)>,ne,dataout_transfer_finish	;SPCI
		while	<tst.b DMAC_CSR(aDMAC)>,pl	;DMAC_CSR_COC
	;DMAI
		move.b	DMAC_CER(aDMAC),d0
		if	ne			;DMAG[
			goto	<cmp.b #DMAC_BUS_ERROR_DEVICE,d0>,eq,dataout_transfer_continue	;foCXAhX̃oXG[͌p
		;foCXAhX̃oXG[ȊODMAG[
		;!!! SPČnĂȂBnOAbv
			moveq.l	#-1,d0
			goto	dataout_transfer_end

		endif
	;DMAG[Ȃ
	;f[^̃AhXƑŜ̎c̒XV
		adda.l	d2,aBUF			;(f[^̃AhX)+=(ubN̒)
		sub.l	d2,dLEN			;(Ŝ̎c̒)-=(ubN̒)
	while	ne			;Ŝ̎c̒0ɂȂ܂ŌJԂ
;SPCI
dataout_transfer_finish:
;SPČn
	moveq.l	#0,d0
	do
		move.b	(aINTS),d0
	while	eq
	move.b	d0,(aINTS)		;INTSNA
	if	<cmp.b #SPC_INTS_CC,d0>,eq	;SPC]I
		moveq.l	#0,d0
	endif
;DMAČn
	if	<tst.w DMAC_MTC(aDMAC)>,ne	;MTC0łȂ
		moveq.l	#-2,d0
	endif
	if	<tst.b DMAC_CSR(aDMAC)>,pl	;DMAC_CSR_COCBDMA]IĂȂ
		move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA]~
	endif
;I
dataout_transfer_end:
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])
;<dLEN.l:f[^̒
;<aBUF.l:obt@̃AhX
;<a6.l:SPCx[XAhX
;>d0.l:0=I,̑=INTS
datain_transfer:
	push	dLEN/aBUF
;0̂Ƃ256ƌȂ
	if	<tst.l dLEN>,eq
		move.w	#256,dLEN
	endif
;tF[YZbg
	move.b	SPC_PSNS(aSPC),d0
	andi.b	#SPC_PHASE_MASK,d0
	move.b	d0,SPC_PCTL(aSPC)
;Zbg
	move.l	dLEN,d0
	move.b	d0,SPC_TCL(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCM(aSPC)	;f[^̒()
	lsr.l	#8,d0
	move.b	d0,SPC_TCH(aSPC)	;f[^̒()
;]Jn
	move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
	move.b	#SPC_SCMD_CC_TR,SPC_SCMD(aSPC)
	bsr	datain_dma		;SCSI(DMA])s
	if	<tst.l d0>,eq
	;荞݂҂
		do
			move.b	SPC_INTS(aSPC),d0
		while	eq
		move.b	SPC_INTS(aSPC),SPC_INTS(aSPC)	;INTSNA
		if	<cmp.b #SPC_INTS_CC,d0>,eq
			moveq.l	#0,d0
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;SCSI(DMA])s
datain_dma:
	push	d1/d2/a0/a3
~dcr = DMAC_NO_HOLD_CYCLE|DMAC_HD68000_COMPATIBLE|DMAC_8_BIT_PORT|DMAC_STATUS_INPUT
;X68000SPCDREQDMACREQ1ɌqĂȂ
;DREQgDTACK̂ŃI[gNGXgő呬xp
~ocr = DMAC_DEVICE_TO_MEMORY|DMAC_UNPACKED_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX
	move.w	#(~dcr<<8)|~ocr,d1
	bsr	cache_flush		;DMA]JnÕLbVtbV
aDMAC	reg	a0
;DMAݒ肷
	lea.l	DMAC_1_BASE,aDMAC
	st.b	DMAC_CSR(aDMAC)		;DMAC_CSRNA
	clr.w	DMAC_BTC(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_FIXED_DEVICE,DMAC_SCR(aDMAC)
	lea.l	SPC_DREG(aSPC),a3
	move.l	a3,DMAC_DAR(aDMAC)
;xɓ]钷߂
	moveq.l	#0,d2
	move.w	#256,d2
	if	<tst.b SRAM_SCSI_MODE>,mi	;SRAM_SCSI_BLOCK_BIT ubN
		moveq.l	#0,d2
		move.w	BIOS_SCSI_BLOCK_SIZE.l,d2	;SCSI@̃ubNTCY
	endif
;o[Xgɂ邩
    .if SCSIEXROM==0
	ifand	<isX68030>,eq,<btst.b #SRAM_SCSI_BURST_BIT,SRAM_SCSI_MODE>,ne	;SCSIX68030o[Xg
~dcr = DMAC_NO_HOLD_CYCLE^DMAC_BURST_TRANSFER
~ocr = DMAC_AUTO_REQUEST_MAX^DMAC_EXTERNAL_REQUEST
		eori.w	#(~dcr<<8)|~ocr,d1
	endif
    .endif
;DMAC_DCRDMAC_OCRݒ肷
	move.w	d1,DMAC_DCR(aDMAC)	;DMAC_DCRDMAC_OCR
aINTS	reg	a3
	lea.l	SPC_INTS(aSPC),aINTS
	do
	;<dLEN.l:̎c̃f[^̒
	;<aBUF.l:̃obt@̃AhX
		if	<cmp.l d2,dLEN>,ls	;c1`ubNTCY
			move.l	dLEN,d2			;]钷͎c̃f[^̒
		endif
	;<d2.l:]钷
	;̃obt@̃AhXƍ]钷DMAɐݒ肷
		move.l	aBUF,DMAC_MAR(aDMAC)	;obt@̃AhX
		move.w	d2,DMAC_MTC(aDMAC)	;]钷
	datain_dma_continue:
	;FIFOłȂȂ܂ő҂
		do
			goto	<tst.b (aINTS)>,ne,datain_dma_interrupted	;SPC荞݂
		while	<btst.b #SPC_SSTS_DE_BIT,SPC_SSTS(aSPC)>,ne
	;DMA]Jn
		st.b	DMAC_CSR(aDMAC)		;CSRNA
		move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
		tst.b	(aINTS)			;ǂ
	;DMA]I҂
		do
			goto	<tst.b (aINTS)>,ne,datain_dma_interrupted	;SPC荞݂
		while	<tst.b DMAC_CSR(aDMAC)>,pl	;DMAC_CSR_COC
	;G[ȂmF
		move.b	DMAC_CER(aDMAC),d0
		goto	ne,datain_dma_error	;DMAG[
	;c̃f[^̒0ɂȂ܂ŌJԂ
		adda.l	d2,aBUF			;̃obt@̃AhX
		sub.l	d2,dLEN			;̎c̃f[^̒
	while	ne
	moveq.l	#0,d0
datain_dma_end:
;DMAC_DARSASIɖ߂
	move.l	#HDC_DATA,DMAC_DAR(aDMAC)
	pop
	rts

;DMAG[
;<d0.b:DMAC_CER
datain_dma_error:
	goto	<cmp.b #DMAC_BUS_ERROR_DEVICE,d0>,eq,datain_dma_continue	;oXG[
;oXG[ȊODMAG[
	moveq.l	#-1,d0
	goto	datain_dma_end

;SPC荞݂
datain_dma_interrupted:
	move.b	SPC_INTS(aSPC),d0
	goto	<cmpi.b #SPC_INTS_CC,d0>,ne,datain_dma_abort	;SPC]IĂȂB]~
;SPC]I
	moveq.l	#0,d0
	goto	<tst.w DMAC_MTC(aDMAC)>,eq,datain_dma_abort	;DMA]IB]~
;SPC͓]IDMA]IĂȂ
	moveq.l	#-2,d0
;]~
datain_dma_abort:
	move.b	#DMAC_CCR_SAB,DMAC_CCR(aDMAC)	;DMA]~
	goto	datain_dma_end


  .endif


;----------------------------------------------------------------
;	https://twitter.com/kamadox/status/1204687543200972805
;	SUPERCompact܂ł̓SCSIDMA]gĂ邪ASPCDREQDMARg[ɌqĂ炸A
;	DTACKBERRœ]̃^C~O𐧌䂵ĂB
;                                                                                                
;                                      [X68000 XVI Compact]                                      
;                                                                                                
;             MC68HC000             DOSA               HD63450                                   
;          +-------------+     +-------------+     +-------------+                               
;          |         BERR|-----|BERR   BEC0/1|-----|BEC0/1   REQ1|--+                            
;          |        DTACK|--+  +-------------+  +--|DTACK        |  |                            
;          +-------------+  |        ASA        |  +-------------+  |                            
;                           |  +-------------+  |       PEDEC       |                            
;                           +--|MPUDTACK     |  |  +-------------+  |      MB89352               
;                              |  +--DMADTACK|--+  |        HDREQ|--+  +-------------+           
;                              |  +-SYNCDTACK|-----|IOCDTK--SIREQ|-----|DREQ         |           
;                              +-------------+     +-------------+     +-------------+           
;                                                                                                
;                                             [X68030]                                           
;                                                                                                
;             MC68EC030             SAKI               HD63450                                   
;          +-------------+     +-------------+     +-------------+                               
;          |         BERR|-----|BERR   BEC0/1|-----|BEC0/1   REQ1|--+                            
;          |     DSACK0/1|--+  +-------------+  +--|DTACK        |  |                            
;          +-------------+  |       YUKI        |  +-------------+  |                            
;                           |  +-------------+  |       PEDEC       |                            
;                           +--|DSACK0/1     |  |  +-------------+  |      MB89352               
;                              |  +--DMADTACK|--+  |        HDREQ|- |  +-------------+           
;                              |  +-SYNCDTACK|-----|IOCDTK--SIREQ|--+--|DREQ         |           
;                              +-------------+     +-------------+     +-------------+           
;                                                                                                
;	DMARg[SPCDREGANZXƂDREQO]vƂĎgȂ̂ŁA
;	I[gNGXgő呬xŃANZXāAoX͂񂾂܂DREQƘAĂDTACK҂B
;	莞ԓɓ]łAoXG[ŋIĂA]p悤ɃvOĂB
;	MOȂǂ̒xfoCXւ݂̏ŁAoXG[鍐^C~OƁA
;	DMARg[U߂悤Ƃf[^SPCMĂ܂ƂB
;	̂܂܌pƓf[^dđMBSCSI BIOS͂ꂪŏ݂Ɏs邱ƂB
;	f[^̏d̓oXG[ƂDMARg[SPC̃JE^rē]ĊJʒu␳邱ƂŉłB
;	fFiloP.xp邩AHuman68k version 3.0FORMAT.XŃtH[}bgn[hfBXNNƑ΍􂪎{B
;----------------------------------------------------------------



;--------------------------------------------------------------------------------
;	.include	sc08cache.s
;--------------------------------------------------------------------------------

  .if 10<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;DMA]JnÕLbVtbV
cache_flush:
    .if SCSI_BIOS_LEVEL<=10
	move.l	d0,-(sp)
	if	<cmpi.b #1,BIOS_MPU_TYPE.w>,hi
		.cpu	68030
		movec.l	cacr,d0
		or.w	#$0808,d0
		movec.l	d0,cacr
		and.w	#$F7F7,d0
		movec.l	d0,cacr
		.cpu	68000
	endif
	move.l	(sp)+,d0
    .else
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs	;020/030/040/060
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;020/030
			move.l	d0,-(sp)
			.cpu	68030
		;68030cacr
		;| 15| 14| 13| 12| 11| 10|  9|  8|  7|  6|  5|  4|  3|  2|  1|  0|
		;|  0|  0| WA|DBE| CD|CED| FD| ED|  0|  0|  0|IBE| CI|CEI| FI| EI|
		;CDCI1ނƃLbVNAŏ0œǂݏoB0łӖȂ
			movec.l	cacr,d0
			or.w	#$0808,d0
			movec.l	d0,cacr
			.cpu	68000
			move.l	(sp)+,d0
		else				;040/060
			.cpu	68040
			cpusha	bc
			.cpu	68000
		endif
	endif
    .endif
	rts
  .endif



;--------------------------------------------------------------------------------
;	.include	sc09sasi.s
;--------------------------------------------------------------------------------

  .if 10<=SCSI_BIOS_LEVEL
;----------------------------------------------------------------
;SASIn[hfBXN
dskini_all:
	push	d0-d4/a1/a6
	move.w	#$8000,d1
	moveq.l	#16-1,d2
	for	d2
		lea.l	0.w,a1
    .if SCSI_BIOS_LEVEL<=10
		bsr	scsi_43_B_DSKINI	;IOCSR[$43 _B_DSKINI(SCSI)
    .else
		bsr	iocs_43_B_DSKINI	;IOCSR[$43 _B_DSKINI
    .endif
		add.w	#1<<8,d1
	next
	pop
	rts
  .endif

  .if SCSI_BIOS_LEVEL<>10
;----------------------------------------------------------------
;SCSIoXɐڑĂSASI@IOCSR[$40`$4Főł悤ɂ
install_sasi_iocs:
	push	d0/d1/d2/d3/d4/a1/aSPC
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_SEEK,d1
	lea.l	iocs_40_B_SEEK(pc),a1	;IOCSR[$40 _B_SEEK
	trap	#15
    .if SCSI_BIOS_LEVEL<=10
	move.l	d0,(BIOS_SCSI_OLD_SEEK)abs	;IOCSR[$40 _B_SEEǨ̃xN^
    .else
	move.l	d0,(BIOS_SCSI_OLD_SEEK_16)abs	;IOCSR[$40 _B_SEEǨ̃xN^
    .endif
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_VERIFY,d1
	lea.l	iocs_41_B_VERIFY(pc),a1	;IOCSR[$41 _B_VERIFY
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_VERIFY)abs	;IOCSR[$41 _B_VERIFY̌̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_DSKINI,d1
	lea.l	iocs_43_B_DSKINI(pc),a1	;IOCSR[$43 _B_DSKINI
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_DSKINI)abs	;IOCSR[$43 _B_DSKINǏ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_DRVSNS,d1
	lea.l	iocs_44_B_DRVSNS(pc),a1	;IOCSR[$44 _B_DRVSNS
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_DRVSNS)abs	;IOCSR[$44 _B_DRVSNŠ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_WRITE,d1
	lea.l	iocs_45_B_WRITE(pc),a1	;IOCSR[$45 _B_WRITE
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_WRITE)abs	;IOCSR[$45 _B_WRITĚ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_READ,d1
	lea.l	iocs_46_B_READ(pc),a1	;IOCSR[$46 _B_READ
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_READ)abs	;IOCSR[$46 _B_REAĎ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_RECALI,d1
	lea.l	iocs_47_B_RECALI(pc),a1	;IOCSR[$47 _B_RECALI
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_RECALI)abs	;IOCSR[$47 _B_RECALǏ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_ASSIGN,d1
	lea.l	iocs_48_B_ASSIGN(pc),a1	;IOCSR[$48 _B_ASSIGN
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_ASSIGN)abs	;IOCSR[$48 _B_ASSIGŇ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_BADFMT,d1
	lea.l	iocs_4B_B_BADFMT(pc),a1	;IOCSR[$4B _B_BADFMT
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_BADFMT)abs	;IOCSR[$4B _B_BADFMŤ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_FORMAT,d1
	lea.l	iocs_4D_B_FORMAT(pc),a1	;IOCSR[$4D _B_FORMAT
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_FORMAT)abs	;IOCSR[$4D _B_FORMAŤ̃xN^
	moveq.l	#_B_INTVCS,d0
	move.w	#$100+_B_EJECT,d1
	lea.l	iocs_4F_B_EJECT(pc),a1	;IOCSR[$4F _B_EJECT
	trap	#15
	move.l	d0,(BIOS_SCSI_OLD_EJECT)abs	;IOCSR[$4F _B_EJECŤ̃xN^
;SASIn[hfBXN
	move.w	#$8000,d1
	moveq.l	#16-1,d2
	for	d2
		movea.l	#0,a1
		bsr	iocs_43_B_DSKINI	;IOCSR[$43 _B_DSKINI
		add.w	#1<<8,d1
	next
	pop
	rts
  .endif

  .if SCSI_BIOS_LEVEL<>10

;----------------------------------------------------------------
;IOCSR[$40 _B_SEEK V[N
iocs_40_B_SEEK:
	move.l	(BIOS_SCSI_OLD_SEEK)abs,-(sp)	;IOCSR[$40 _B_SEEǨ̃xN^
	push	d1/d4/a5
	lea.l	scsi_2D_S_SEEK(pc),a5	;SCSIR[$2D _S_SEEK
	goto	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;IOCSR[$47 _B_RECALI gbN0ւ̃V[N
iocs_47_B_RECALI:
	move.l	(BIOS_SCSI_OLD_RECALI)abs,-(sp)	;IOCSR[$47 _B_RECALǏ̃xN^
	push_again
	lea.l	scsi_2B_S_REZEROUNIT(pc),a5	;SCSIR[$2B _S_REZEROUNIT
	goto	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;IOCSR[$48 _B_ASSIGN
iocs_48_B_ASSIGN:
	move.l	(BIOS_SCSI_OLD_ASSIGN)abs,-(sp)	;IOCSR[$48 _B_ASSIGŇ̃xN^
	push_again
	lea.l	scsi_39_S_ASSIGN(pc),a5	;SCSIR[$39 _S_ASSIGN
	goto	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;IOCSR[$4B _B_BADFMT obhgbNgps\ɂ
iocs_4B_B_BADFMT:
	move.l	(BIOS_SCSI_OLD_BADFMT)abs,-(sp)	;IOCSR[$4B _B_BADFMŤ̃xN^
	push_again
	lea.l	scsi_38_S_BADFMT(pc),a5	;SCSIR[$38 _S_BADFMT
	goto	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;IOCSR[$4D _B_FORMAT tH[}bg
iocs_4D_B_FORMAT:
	move.l	(BIOS_SCSI_OLD_FORMAT)abs,-(sp)	;IOCSR[$4D _B_FORMAŤ̃xN^
	push_again
	lea.l	scsi_37_S_FORMATB(pc),a5	;SCSIR[$37 _S_FORMATB
	goto	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;IOCSR[$44 _B_DRVSNS
iocs_44_B_DRVSNS:
	move.l	(BIOS_SCSI_OLD_DRVSNS)abs,-(sp)	;IOCSR[$44 _B_DRVSNŠ̃xN^
	push_again
	lea.l	scsi_24_S_TESTUNIT(pc),a5	;SCSIR[$24 _S_TESTUNIT
;!!! ւbraBTCYȂƍ폜
	bra.w	iocs_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F̏

;----------------------------------------------------------------
;_B_SEEKA_B_RECALIA_B_ASSIGNA_B_BADFMTA_B_FORMATA_B_DRVSNS
iocs_40_44_47_48_4b_4d_common:

  .else

;----------------------------------------------------------------
;IOCSR[$40 _B_SEEK V[N
scsi_40_B_SEEK:
	lea.l	scsi_2D_S_SEEK(pc),a0	;SCSIR[$2D _S_SEEK
	goto	scsi_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F(SCSI)̏

;----------------------------------------------------------------
;IOCSR[$47 _B_RECALI gbN0ւ̃V[N
scsi_47_B_RECALI:
	lea.l	scsi_2B_S_REZEROUNIT(pc),a0	;SCSIR[$2B _S_REZEROUNIT
	goto	scsi_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F(SCSI)̏

;----------------------------------------------------------------
;IOCSR[$48 _B_ASSIGN
scsi_48_B_ASSIGN:
	lea.l	scsi_39_S_ASSIGN(pc),a0	;SCSIR[$39 _S_ASSIGN
	goto	scsi_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F(SCSI)̏

;----------------------------------------------------------------
;IOCSR[$4B _B_BADFMT obhgbNgps\ɂ
scsi_4B_B_BADFMT:
	lea.l	scsi_38_S_BADFMT(pc),a0	;SCSIR[$38 _S_BADFMT
	goto	scsi_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F(SCSI)̏

;----------------------------------------------------------------
;IOCSR[$4D _B_FORMAT tH[}bg
scsi_4D_B_FORMAT:
	lea.l	scsi_37_S_FORMATB(pc),a0	;SCSIR[$37 _S_FORMATB
	goto	scsi_40_44_47_48_4b_4d_common	;IOCSR[$40`$4F(SCSI)̏

;----------------------------------------------------------------
;IOCSR[$44 _B_DRVSNS
scsi_44_B_DRVSNS:
	lea.l	scsi_24_S_TESTUNIT(pc),a0	;SCSIR[$24 _S_TESTUNIT
;----------------------------------------------------------------
;_B_SEEKA_B_RECALIA_B_ASSIGNA_B_BADFMTA_B_FORMATA_B_DRVSNS
scsi_40_44_47_48_4b_4d_common:
	push	d1/d4/a5
	movea.l	a0,a5

  .endif

	moveq.l	#0,d4
	move.w	d1,d4
  .if SCSI_BIOS_LEVEL<>10
	andi.w	#$F000,d1
	goto	<cmp.w #$8000,d1>,ne,iocs_40_44_47_48_4b_4d_not_hd	;HDł͂Ȃ
  .endif
	lsr.w	#8,d4
	lsr.w	#1,d4			;SCSI-ID=HD-ID/2
	if	cs
		bset.l	#16,d4			;LUN=HD-ID%2
	endif
	andi.w	#7,d4			;SCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,eq,scsi_40_44_47_48_4b_4d_not_sasi	;SASItOZbgĂȂ
	jsr	(a5)			;SCSIR[Ă
;<d0.l:0=,-1=s,̑=MSGIN<<16|STSIN

  .if SCSI_BIOS_LEVEL<>10

    .if SCSI_BIOS_LEVEL<=10
      .if 4<=SCSI_BIOS_LEVEL
	andi.l	#$FFFFFF1E,d0		;SASĨXe[^XoCg̈ꕔ𖳎
      .endif
	goto	<tst.l d0>,ne,scsi_40_44_47_48_4b_4d_error
    .else
	goto	<btst.l #1,d0>,ne,scsi_40_44_47_48_4b_4d_error	;Check Condition
    .endif
	moveq.l	#0,d0
	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	rts

scsi_40_44_47_48_4b_4d_error:
	ori.l	#$FFFFFF00,d0
	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	rts

;SASItOZbgĂȂ
scsi_40_44_47_48_4b_4d_not_sasi:
;HDł͂Ȃ
iocs_40_44_47_48_4b_4d_not_hd:
	pop
	rts				;̏Ă

  .else

	goto	<btst.l #1,d0>,ne,scsi_40_44_47_48_4b_4d_error	;Check Condition
	moveq.l	#0,d0
scsi_40_44_47_48_4b_4d_end:
	pop
	rts

;SASItOZbgĂȂ
scsi_40_44_47_48_4b_4d_not_sasi:
	moveq.l	#-1,d0
scsi_40_44_47_48_4b_4d_error:
	ori.l	#$FFFFFF00,d0
	goto	scsi_40_44_47_48_4b_4d_end

  .endif

;----------------------------------------------------------------
;IOCSR[$4F _B_EJECT CWFNg^VbsO
;<d1.w:
;	FD	$9000|FD-ID(0`3)<<8|MFM(0`1)<<6|RETRY(0`1)<<5|SEEK(0`1)<<4
;	HD	$8000|HD-ID(0`15)<<8
;		HD-ID(0`15)=SCSI-ID(0`7)<<1|LUN(0`1)
;>d0.l:
;	FD	s
;	HD	0ȏ=,-1ȉ=s
  .if SCSI_BIOS_LEVEL<>10
iocs_4F_B_EJECT:
	move.l	(BIOS_SCSI_OLD_EJECT)abs,-(sp)
  .else
scsi_4F_B_EJECT:
  .endif
	push	d1/d2/d3/d4/d5/d6/d7/a1/a4
	moveq.l	#0,d4
	move.w	d1,d4
  .if SCSI_BIOS_LEVEL<>10
	andi.w	#$F000,d1
	goto	<cmp.w #$8000,d1>,ne,iocs_4f_not_hd	;HDł͂Ȃ
  .endif
	move.l	d4,d1
	lsr.w	#8,d4
	lsr.w	#1,d4			;SCSI-ID=HD-ID/2
	if	cs
		bset.l	#16,d4			;LUN=HD-ID%2
	endif
	andi.w	#7,d4			;SCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,eq,scsi_4f_not_sasi	;SASItOZbgĂȂ

  .if SCSI_BIOS_LEVEL<=4

	lea.l	BIOS_SASI_CAPACITY.l,a4	;SASIn[hfBXN̗eʂ̔zB0=mF,10=10MB,20=20MB,40=40MB,128=ڑ
	move.l	d1,d0
	ror.w	#8,d0
	and.l	#15,d0			;HD-ID
	adda.l	d0,a4
	move.b	(a4),d0
	if	<btst.l #7,d0>,eq	;ڑ
		and.b	#$7F,d0
		if	ne			;mFς
			move.l	#33*4*664,d2		;20MBVbsO][
		;!!! sv
    .if SCSI_BIOS_LEVEL<=0
			lea.l	sasi_20mb_shipping_parameter,a1	;20MBhCup[^(VbsO][)
    .else
			lea.l	sasi_20mb_shipping_parameter(pc),a1	;20MBhCup[^(VbsO][)
    .endif
			if	<cmp.b #20,d0>,ne	;20MB
				move.l	#33*8*664,d2		;40MBVbsO][
			;!!! sv
    .if SCSI_BIOS_LEVEL<=0
				lea.l	sasi_40mb_shipping_parameter,a1	;40MBhCup[^(VbsO][)
    .else
				lea.l	sasi_40mb_shipping_parameter(pc),a1	;40MBhCup[^(VbsO][)
    .endif
				if	<cmp.b #40,d0>,ne	;40MB
					move.l	#33*4*340,d2		;10MBVbsO][
				;!!! sv
    .if SCSI_BIOS_LEVEL<=0
					lea.l	sasi_10mb_shipping_parameter,a1	;10MBhCup[^(VbsO][)
    .else
					lea.l	sasi_10mb_shipping_parameter(pc),a1	;10MBhCup[^(VbsO][)
    .endif
				endif
			endif
		;!!! ROM 1.0`1.2SASI BIOS_B_EJECT̓VbsO][SET DRIVE PARAMETERĂSEEKĂ
			bsr	scsi_2D_S_SEEK		;SCSIR[$2D _S_SEEK
		endif
	endif
;ڑ܂͖mF
;+++++ BUG +++++
;SASIn[hfBXNVbsOłȂȂ
;	SASItOZbgĂȂƂSASIn[hfBXNVbsOȂ΂ȂȂ̂Ɍ̏ĂłȂ
;SASItOZbgĂȂ
scsi_4f_not_sasi:
;+++++ BUG +++++
	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	rts

;HDł͂Ȃ
iocs_4f_not_hd:
	pop
	rts				;̏Ă

;+++++ BUG +++++
;ǂQƂĂȂ
	andi.w	#$F000,d1
	if	<cmp.w #$8000,d1>,eq
		movem.l	(sp)+,d1
		addq.l	#4,sp
		moveq.l	#0,d0
		rts

	endif
	movem.l	(sp)+,d1
	rts
;+++++ BUG +++++

  .else

	lea.l	BIOS_SASI_CAPACITY.w,a4	;SASIn[hfBXN̗eʂ̔zB0=mF,10=10MB,20=20MB,40=40MB,128=ڑ
	move.w	d1,d0
	ror.w	#8,d0
	and.w	#15,d0			;HD-ID
	move.b	(a4,d0.w),d0
;!!! sv
	ifand	<tst.b d0>,pl,<>,ne
	;ڑAmFς
		move.l	#33*4*664,d2		;20MBVbsO][
		if	<cmp.b #20,d0>,ne
			move.l	#33*8*664,d2		;40MBVbsO][
			if	<cmp.b #40,d0>,ne
				move.l	#33*4*340,d2		;10MBVbsO][
				if	<cmp.b #10,d0>,ne
					goto	scsi_4f_end		;10MB/20MB/40MB̂łȂ
				endif
			endif
		endif
	;!!! ROM 1.0`1.2SASI BIOS_B_EJECT̓VbsO][SET DRIVE PARAMETERĂSEEKĂ
		bsr	scsi_2D_S_SEEK		;SCSIR[$2D _S_SEEK
		moveq.l	#0,d0
	endif
;ڑ܂͖mF
scsi_4f_end:

    .if SCSI_BIOS_LEVEL<=10

;SASItOZbgĂȂ
scsi_4f_not_sasi:
	pop
	rts

    .else

	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	rts

;SASItOZbgĂȂ
scsi_4f_not_sasi:
;HDł͂Ȃ
iocs_4f_not_hd:
	pop
	rts				;̏Ă

    .endif

  .endif

;----------------------------------------------------------------
;IOCSR[$46 _B_READ ǂݏo
;<d1.w:hCu
;	HD	$8000|HD-ID(0`15)<<8
;		HD-ID(0`15)=SCSI-ID(0`7)<<1|LUN(0`1)
;	FD	$9000|FD-ID(0`3)<<8|MFM(0`1)<<6|RETRY(0`1)<<5|SEEK(0`1)<<4
;<d2.l:ʒu
;	HD	R[hԍ
;	FD	R[h(0`7)<<24|V_ԍ(0`)<<16|wbhԍ(0`1)<<8|ZN^ԍ(1`)
;<d3.l:oCg
;<a1.l:AhX
;>d0.l:
;	HD	0ȏ=,-1ȉ=sB$FFFFFF00|G[R[h=s
;	FD	ST0<<24|ST1<<16|ST2<<8|V_ԍ
;----------------------------------------------------------------
;IOCSR[$45 _B_WRITE 
;<d1.w:hCu
;	HD	$8000|HD-ID(0`15)<<8
;		HD-ID(0`15)=SCSI-ID(0`7)<<1|LUN(0`1)
;	FD	$9000|FD-ID(0`3)<<8|MFM(0`1)<<6|RETRY(0`1)<<5|SEEK(0`1)<<4
;<d2.l:ʒu
;	HD	R[hԍ
;	FD	R[h(0`7)<<24|V_ԍ(0`)<<16|wbhԍ(0`1)<<8|ZN^ԍ(1`)
;<d3.l:oCg
;<a1.l:AhX
;>d0.l:
;	HD	0ȏ=,$FFFFFF00|STSIN=s
;	FD	ST0<<24|ST1<<16|ST2<<8|V_ԍ

  .if SCSI_BIOS_LEVEL<>10

iocs_46_B_READ:
	move.l	(BIOS_SCSI_OLD_READ)abs,-(sp)	;IOCSR[$46 _B_REAĎ̃xN^
	push	d1/d2/d3/d4/d5/d6/a1/a2/a5
	lea.l	scsi_21_S_READ(pc),a5	;SCSIR[$21 _S_READ
	goto	iocs_45_46_common	;_B_READA_B_WRITE

iocs_45_B_WRITE:
	move.l	(BIOS_SCSI_OLD_WRITE)abs,-(sp)	;IOCSR[$45 _B_WRITĚ̃xN^
	push_again
	lea.l	scsi_22_S_WRITE(pc),a5	;SCSIR[$22 _S_WRITE
;!!! ւbraBTCYȂƍ폜
	bra.w	iocs_45_46_common		;_B_READA_B_WRITE

;_B_READA_B_WRITE
;<a5.l:_S_READ܂_S_WRITE
iocs_45_46_common:

  .else

scsi_46_B_READ:
	lea.l	scsi_21_S_READ(pc),a0	;SCSIR[$21 _S_READ
	goto	scsi_45_46_common	;_B_READ(SCSI)A_B_WRITE(SCSI)

scsi_45_B_WRITE:
	lea.l	scsi_22_S_WRITE(pc),a0	;SCSIR[$22 _S_WRITE
;_B_READA_B_WRITE
;<a0.l:_S_READ܂_S_WRITE
scsi_45_46_common:
	push	d1/d2/d3/d4/d5/d6/a1/a2/a5
	movea.l	a0,a5			;_S_READ܂_S_WRITE

  .endif

	moveq.l	#0,d4
	move.w	d1,d4
  .if SCSI_BIOS_LEVEL<>10
	andi.w	#$F000,d1
	goto	<cmp.w #$8000,d1>,ne,iocs_45_46_not_hd	;HDł͂Ȃ
  .endif
	lsr.w	#8,d4
	lsr.w	#1,d4			;SCSI-ID=HD-ID/2
	if	cs
		bset.l	#16,d4			;LUN=HD-ID%2
	endif
	andi.w	#7,d4			;SCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,eq,scsi_45_46_not_sasi	;SASItOZbgĂȂ
	move.l	d3,d6			;c̃oCg
	do
		move.l	d6,d3			;c̃oCg
		add.l	#255,d3
		lsr.l	#8,d3			;̃R[hB256oCg/R[h
		if	<cmp.l #256,d3>,hi
			move.l	#256,d3			;xɓ]郌R[h̏
		endif
		moveq.l	#0,d5			;R[hB0=256oCg/R[h
		jsr	(a5)			;_S_READ܂_S_WRITE
  .if SCSI_BIOS_LEVEL<=3
	;+++++ BUG +++++
	;_S_READ܂_S_WRITEG[zŕԂȂƌołȂ
	;+++++ BUG +++++
		goto	ne,scsi_45_46_error
  .elif SCSI_BIOS_LEVEL<=4
		andi.l	#$FFFFFF1E,d0		;SASĨXe[^XoCg̈ꕔ𖳎
		goto	<tst.l d0>,ne,scsi_45_46_error
  .else
		goto	<btst.l #1,d0>,ne,scsi_45_46_error	;Check Condition
  .endif
		add.l	d3,d2			;̃R[hԍ
		move.l	d3,d1
		lsl.l	#8,d1			;̃oCg
		adda.l	d1,a1			;̃AhX
		sub.l	d1,d6			;̎c̃oCg
	while	hi

  .if SCSI_BIOS_LEVEL<>10

	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	moveq.l	#0,d0
	rts

scsi_45_46_error:
	pop_test
	addq.l	#4,sp			;̏Ă΂Ȃ
	ori.l	#$FFFFFF00,d0
	rts

;SASItOZbgĂȂ
scsi_45_46_not_sasi:
;HDł͂Ȃ
iocs_45_46_not_hd:
	pop
	rts				;̏Ă

  .else

	moveq.l	#0,d0
scsi_45_46_end:
	pop
	rts

;SASItOZbgĂȂ
scsi_45_46_not_sasi:
	moveq.l	#-1,d0
scsi_45_46_error:
	ori.l	#$FFFFFF00,d0
	goto	scsi_45_46_end

  .endif

;----------------------------------------------------------------
;IOCSR[$41 _B_VERIFY xt@C
;<d1.w:hCu
;	HD	$8000|HD-ID(0`15)<<8
;		HD-ID(0`15)=SCSI-ID(0`7)<<1|LUN(0`1)
;	FD	$9000|FD-ID(0`3)<<8|MFM(0`1)<<6|RETRY(0`1)<<5|SEEK(0`1)<<4
;<d2.l:ʒu
;	HD	R[hԍ
;	FD	R[h(0`7)<<24|V_ԍ(0`)<<16|wbhԍ(0`1)<<8|ZN^ԍ(1`)
;<d3.l:oCg
;<a1.l:AhX
;>d0.l:
;	HD	0=v,-2=sv
;	FD	ST0<<24|PCN<<16
  .if SCSI_BIOS_LEVEL<>10
iocs_41_B_VERIFY:
  .else
scsi_41_B_VERIFY:
  .endif
	link.w	a4,#-256
	push	d1/d2/d3/d4/d5/d6/a1/a2
	moveq.l	#0,d4
	move.w	d1,d4
  .if SCSI_BIOS_LEVEL<>10
	andi.w	#$F000,d1
	goto	<cmp.w #$8000,d1>,ne,iocs_b_verify_not_hd	;HDł͂Ȃ
	move.l	d4,d1
  .endif
	lsr.w	#8,d4
	lsr.w	#1,d4			;SCSI-ID=HD-ID/2
	if	cs
		bset.l	#16,d4			;LUN=HD-ID%2
	endif
	andi.w	#7,d4			;SCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,eq,scsi_b_verify_not_sasi	;SASItOZbgĂȂ
	movea.l	a1,a2			;AhX
	move.l	d3,d6			;c̃oCg
	do
		move.l	d6,d3			;c̃oCg
		if	<cmp.l #256,d3>,cc
			move.l	#256,d3			;xɓǂݍރoCg̏B256oCg/R[h
		endif
	;!!! X[p[oCUX^bNɓǂݍłB[JƂDMA͂Ƃ͌Ȃ
		lea.l	-256(a4),a1
  .if SCSI_BIOS_LEVEL<>10
		bsr	iocs_46_B_READ		;IOCSR[$46 _B_READ ǂݏo
  .else
		bsr	scsi_46_B_READ		;IOCSR[$46 _B_READ(SCSI) ǂݏo
  .endif
		move.l	d3,d5
		subq.l	#1,d5
		for	d5
			cmpm.b	(a1)+,(a2)+
			goto	ne,scsi_b_verify_error	;sv
		next
		addq.l	#1,d2			;̃R[hԍ
		sub.l	d3,d6			;̎c̃oCg
	while	hi

  .if SCSI_BIOS_LEVEL<>10

	pop_test
	unlk	a4
	moveq.l	#0,d0			;v
	rts				;̏Ă΂Ȃ

scsi_b_verify_error:
	moveq.l	#-2,d0			;sv
	pop_test
	unlk	a4
	ori.l	#$FFFFFF00,d0		;-2̂܂
	rts				;̏Ă΂Ȃ

;SASItOZbgĂȂ
scsi_b_verify_not_sasi:
;HDł͂Ȃ
iocs_b_verify_not_hd:
	pop
	unlk	a4
	move.l	(BIOS_SCSI_OLD_VERIFY)abs,-(sp)	;IOCSR[$41 _B_VERIFY̌̃xN^
	rts				;̏Ă

  .else

	moveq.l	#0,d0			;v
scsi_b_verify_end:
	pop
	unlk	a4
	rts

scsi_b_verify_error:
	moveq.l	#-2,d0			;sv
	ori.l	#$FFFFFF00,d0		;-2̂܂
	goto	scsi_b_verify_end

;SASItOZbgĂȂ
scsi_b_verify_not_sasi:
	moveq.l	#-1,d0
	goto	scsi_b_verify_end

  .endif

;----------------------------------------------------------------
;IOCSR[$43 _B_DSKINI 
;<d1.w:hCu
;	HD	$8000|HD-ID(0`15)<<8
;		HD-ID(0`15)=SCSI-ID(0`7)<<1|LUN(0`1)
;	FD	$9000|FD-ID(0`3)<<8
;<d2.w:
;	HD	Ȃ
;	FD	[^[~(10msP)B0=ftHg(2b)
;<a1.l:
;	HD	hCup[^̃AhXB0=ftHg
;	FD	SpecifyR}h̃AhXB0=ftHg
;>d0.l:
;	HD	0=,$FFFFFF00|STSIN=s
;	FD	ST3<<24|s
  .if SCSI_BIOS_LEVEL<>10
iocs_43_B_DSKINI:
  .else
scsi_43_B_DSKINI:
  .endif
	link.w	a4,#-256
  .if SCSI_BIOS_LEVEL<=10
;+++++ BUG +++++
;d5/a2j󂵂Ă
	push	d1/d2/d3/d4/a1/a5
;+++++ BUG +++++
  .else
	push	d1/d2/d3/d4/d5/a1/a2/a5
  .endif
	moveq.l	#0,d4
	move.w	d1,d4
  .if SCSI_BIOS_LEVEL<>10
	andi.w	#$F000,d1
	goto	<cmp.w #$8000,d1>,ne,iocs_b_dskini_not_hd	;HDł͂Ȃ
  .endif
	lsr.w	#8,d4
	lsr.w	#1,d4			;SCSI-ID=HD-ID/2
	if	cs
		bset.l	#16,d4			;LUN=HD-ID%2
	endif
	andi.w	#7,d4			;SCSI-ID
	goto	<btst.b d4,SRAM_SCSI_SASI_FLAG>,eq,scsi_b_dskini_not_sasi	;SASItOZbgĂȂ
	move.l	a1,d0			;p[^
	goto	eq,scsi_b_dskini_default	;ftHg̃hCup[^g
scsi_b_dskini_go:
	moveq.l	#10,d3			;hCup[^̒B10oCg
	bsr	scsi_36_S_DSKINI	;SCSIR[$36 _S_DSKINI

  .if SCSI_BIOS_LEVEL<>10

    .if SCSI_BIOS_LEVEL<=10
      .if 4<=SCSI_BIOS_LEVEL
	andi.l	#$FFFFFF1E,d0		;SASĨXe[^XoCg̈ꕔ𖳎
      .endif
	goto	<tst.l d0>,ne,scsi_b_dskini_error	;s
    .else
	goto	<btst.l #1,d0>,ne,scsi_b_dskini_error	;Check Condition
    .endif
    .if SCSI_BIOS_LEVEL<=3
	;!!! bsr$617Eœ͂$61000080ɂȂĂ
	bsr.w	sasi_param_to_capacity	;hCup[^SASIn[hfBXN̗eʂ߂
    .else
	bsr	sasi_param_to_capacity	;hCup[^SASIn[hfBXN̗eʂ߂
    .endif
	moveq.l	#0,d0
	pop_test
	unlk	a4
	rts				;̏Ă΂Ȃ

;s
scsi_b_dskini_error:
	ori.l	#$FFFFFF00,d0
	pop_test
	unlk	a4
	rts				;̏Ă΂Ȃ

;SASItOZbgĂȂ
scsi_b_dskini_not_sasi:
;HDł͂Ȃ
iocs_b_dskini_not_hd:
	pop
	unlk	a4
	move.l	(BIOS_SCSI_OLD_DSKINI)abs,-(sp)	;IOCSR[$43 _B_DSKINǏ̃xN^
	rts				;̏Ă

  .else

	goto	<btst.l #1,d0>,ne,scsi_b_dskini_error	;Check Condition
;hCup[^SASIn[hfBXN̗eʂ߂
	lea.l	BIOS_SASI_CAPACITY.w,a5	;SASIn[hfBXN̗eʂ̔zB0=mF,10=10MB,20=20MB,40=40MB,128=ڑ
	move.w	d1,d0
	ror.w	#8,d0
	and.w	#15,d0			;HD-ID
	adda.w	d0,a5
	moveq.l	#40,d0			;40MB
	if	<cmpi.b #$07,3(a1)>,ne
		moveq.l	#20,d0			;20MB
		if	<cmpi.b #$02,4(a1)>,ne
			moveq.l	#10,d0			;10MB
		endif
	endif
	move.b	d0,(a5)
	moveq.l	#0,d0
scsi_b_dskini_end:
	pop
	unlk	a4
	rts

;SASItOZbgĂȂ
scsi_b_dskini_not_sasi:
	moveq.l	#-1,d0
;Check Condition
scsi_b_dskini_error:
	ori.l	#$FFFFFF00,d0
	goto	scsi_b_dskini_end

  .endif

;ftHg̃hCup[^g
scsi_b_dskini_default:
	moveq.l	#10,d3			;hCup[^̒B10oCg
  .if SCSI_BIOS_LEVEL<=4
;20MBhCup[^(VbsO][)ݒ肷
    .if SCSI_BIOS_LEVEL<=0
	lea.l	sasi_20mb_shipping_parameter,a1	;20MBhCup[^(VbsO][)
    .else
	lea.l	sasi_20mb_shipping_parameter(pc),a1	;20MBhCup[^(VbsO][)
    .endif
  .else
;40MBhCup[^(VbsO][)ݒ肷
	lea.l	sasi_40mb_shipping_parameter(pc),a1	;40MBhCup[^(VbsO][)
  .endif
	bsr	scsi_36_S_DSKINI	;SCSIR[$36 _S_DSKINI
  .if SCSI_BIOS_LEVEL<=4
    .if 4<=SCSI_BIOS_LEVEL
	andi.l	#$FFFFFF1E,d0		;SASĨXe[^XoCg̈ꕔ𖳎
    .endif
	goto	<tst.l d0>,ne,scsi_b_dskini_error
  .else  ;10<=SCSI_BIOS_LEVEL
	goto	<btst.l #1,d0>,ne,scsi_b_dskini_error	;Check Condition
  .endif
;R[h4256oCgǂݍ
	lea.l	-256(a4),a1
	moveq.l	#$0400/256,d2
	moveq.l	#$0100/256,d3
	moveq.l	#0,d5			;256oCg/R[h
	bsr	scsi_21_S_READ		;SCSIR[$21 _S_READ
  .if SCSI_BIOS_LEVEL<=4
    .if 4<=SCSI_BIOS_LEVEL
	andi.l	#$FFFFFF1E,d0		;SASĨXe[^XoCg̈ꕔ𖳎
    .endif
	goto	<tst.l d0>,ne,scsi_b_dskini_error	;ǂݍ߂Ȃ
  .else  ;10<=SCSI_BIOS_LEVEL
	goto	<btst.l #1,d0>,ne,scsi_b_dskini_error	;Check Condition
  .endif
	lea.l	-256(a4),a2
  .if SCSI_BIOS_LEVEL<=4
    .if SCSI_BIOS_LEVEL<=0
	lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
    .else
	lea.l	sasi_10mb_drive_parameter(pc),a1	;10MBhCup[^
    .endif
	goto	<cmpi.l #'X68K',0.w(a2)>,ne,scsi_b_dskini_error	;uĂȂ
;uĂ
    .if SCSI_BIOS_LEVEL<=0
	lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
    .else
	lea.l	sasi_10mb_drive_parameter(pc),a1	;10MBhCup[^
    .endif
	move.l	4(a2),d0		;R[h
  .else  ;10<=SCSI_BIOS_LEVEL
	goto	<cmpi.l #'X68K',(a2)+>,ne,scsi_b_dskini_error	;uĂȂ
;uĂ
	lea.l	sasi_10mb_drive_parameter(pc),a1	;10MBhCup[^
	move.l	(a2),d0			;R[h
  .endif
	goto	<cmp.l #33*4*310+1,d0>,cs,scsi_b_dskini_go	;10MB309V_310V_܂10MBƌȂ
	lea.l	sasi_20mb_drive_parameter-sasi_10mb_drive_parameter(a1),a1	;20MBhCup[^
	goto	<cmp.l #33*4*615+1,d0>,cs,scsi_b_dskini_go	;20MB614V_615V_܂20MBƌȂ
	lea.l	sasi_40mb_drive_parameter-sasi_20mb_drive_parameter(a1),a1	;40MBhCup[^
	goto	scsi_b_dskini_go

  .if SCSI_BIOS_LEVEL<>10
;----------------------------------------------------------------
;hCup[^SASIn[hfBXN̗eʂ߂
;<d1.w:HD-ID<<8
;<a1.l:hCup[^
sasi_param_to_capacity:
	lea.l	BIOS_SASI_CAPACITY.l,a5	;SASIn[hfBXN̗eʂ̔zB0=mF,10=10MB,20=20MB,40=40MB,128=ڑ
	move.l	d1,d0
	ror.w	#8,d0
	and.l	#15,d0			;HD-ID
	adda.l	d0,a5
	move.b	#40,d0			;40MB
	if	<cmpi.b #$07,3(a1)>,ne
		move.b	#20,d0			;20MB
		if	<cmpi.b #$02,4(a1)>,ne
			move.b	#10,d0			;10MB
		endif
	endif
	move.b	d0,(a5)
	clr.l	d0
	rts
  .endif

  .if SCSI_BIOS_LEVEL<=0
;----------------------------------------------------------------
;Test Unit ReadyR}h
test_unit_ready_command:
	.dc.b	$00			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Rezero UnitR}h
rezero_unit_command:
	.dc.b	$01			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Read(6)R}h
read_6_command_2nd:
	.dc.b	$08			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Read CapacityR}h
read_capacity_command:
	.dc.b	$25			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 Reserved
	.dc.b	$00			;8 Reserved#######|PMI
	.dc.b	$00			;9 Rg[oCg

;----------------------------------------------------------------
;InquiryR}h
inquiry_command:
	.dc.b	$12			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|EVPD
	.dc.b	$00			;2 y[WR[h
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Request SenseR}h
request_sense_command:
	.dc.b	$03			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Mode Sense(6)R}h
mode_sense_6_command:
	.dc.b	$1A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|R|DBD|Reserved###
	.dc.b	$00			;2 PC##|y[WR[h######
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 AP[V
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Mode Select(6)R}h
mode_select_6_command:
	.dc.b	$15			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|PF|Reserved###|SP
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 p[^Xg
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Reassign BlocksR}h
reassign_blocks_command:
	.dc.b	$07			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Read(6)R}h
read_6_command:
	.dc.b	$08			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Write(6)R}h
write_6_command:
	.dc.b	$0A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|_ubNAhX()#####
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3 _ubNAhX()
	.dc.b	$00			;4 ]f[^
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Read(10)R}h
read_10_command:
	.dc.b	$28			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|FUA|Reserved##|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg

;----------------------------------------------------------------
;Write(10)R}h
write_10_command:
	.dc.b	$2A			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|FUA|Reserved##|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg

;----------------------------------------------------------------
;Verify(10)R}h
verify_10_command:
	.dc.b	$2F			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|DPO|Reserved##|BytChk|RelAdr
	.dc.b	$00			;2 _ubNAhX()
	.dc.b	$00			;3   :
	.dc.b	$00			;4   :
	.dc.b	$00			;5 _ubNAhX()
	.dc.b	$00			;6 Reserved
	.dc.b	$00			;7 ]f[^()
	.dc.b	$00			;8 ]f[^()
	.dc.b	$00			;9 Rg[oCg

;----------------------------------------------------------------
;Prevent-Allow Medium RemovalR}h
prevent_allow_command:
	.dc.b	$1E			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved#####
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved#######|Prevent
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Start-Stop Unit(Eject SONY MO)R}h
start_stop_unit_command:
	.dc.b	$1B			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|Reserved####|Immed
	.dc.b	$00			;2 Reserved
	.dc.b	$00			;3 Reserved
	.dc.b	$00			;4 Reserved######|LoEj|Start
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Load/Unload SHARP MOR}h
load_unload_command:
	.dc.b	$C1			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|#####
	.dc.b	$00			;2
	.dc.b	$00			;3
	.dc.b	$00			;4 #######|LoEj
	.dc.b	$00			;5

;----------------------------------------------------------------
;Seek(6)R}h
seek_6_command:
	.dc.b	$0B			;0 Iy[VR[h
	.dc.b	$00			;1 LUN###|ubNԍ()#####
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 Reserved
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Assign Drive(SASI)R}h
assign_drive_sasi_command:
	.dc.b	$C2			;0 Iy[VR[h
	.dc.b	$00			;1
	.dc.b	$00			;2
	.dc.b	$00			;3
	.dc.b	$00			;4
	.dc.b	$00			;5 f[^̒

;----------------------------------------------------------------
;Format Block(SASI)R}h
format_block_sasi_command:
	.dc.b	$06			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5

;----------------------------------------------------------------
;Bad Track Format(SASI)R}h
bad_track_format_sasi_command:
	.dc.b	$07			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5 Rg[oCg

;----------------------------------------------------------------
;Assign Track(SASI)R}h
assign_track_sasi_command:
	.dc.b	$0E			;0 Iy[VR[h
	.dc.b	$00			;1 ubNԍ()
	.dc.b	$00			;2 ubNԍ()
	.dc.b	$00			;3 ubNԍ()
	.dc.b	$00			;4 C^[u
	.dc.b	$00			;5
  .endif

;----------------------------------------------------------------
;10MBhCup[^
sasi_10mb_drive_parameter:
	.dc.b	$01,$01,$00,$03,$01,$35,$80,$00,$00,$00
;				~~~~~~~309
;			    ~~~4-1
  .if SCSI_BIOS_LEVEL<>10
;10MBhCup[^(VbsO][)
sasi_10mb_shipping_parameter:
	.dc.b	$01,$01,$00,$03,$01,$54,$80,$00,$00,$00
;				~~~~~~~340
;			    ~~~4-1
  .endif
;20MBhCup[^
sasi_20mb_drive_parameter:
	.dc.b	$01,$01,$00,$03,$02,$66,$80,$00,$00,$00
;				~~~~~~~614
;			    ~~~4-1
  .if SCSI_BIOS_LEVEL<>10
;20MBhCup[^(VbsO][)
sasi_20mb_shipping_parameter:
	.dc.b	$01,$01,$00,$03,$02,$98,$80,$00,$00,$00
;				~~~~~~~664
;			    ~~~4-1
  .endif
;40MBhCup[^
sasi_40mb_drive_parameter:
	.dc.b	$01,$01,$00,$07,$02,$66,$80,$00,$00,$00
;				~~~~~~~614
;			    ~~~8-1
;40MBhCup[^(VbsO][)
sasi_40mb_shipping_parameter:
	.dc.b	$01,$01,$00,$07,$02,$98,$80,$00,$00,$00
;				~~~~~~~664
;			    ~~~8-1

;----------------------------------------------------------------
;SASIn[hfBXN
;
;	\
;		10MB	20MB	40MB
;		256	256	256	oCg/R[h
;		33	33	33	R[h/gbN
;		4	4	8	gbN/V_
;		309	614	614	V_/{[
;		340	664	664	VbsO][
;
;	SASIfBXNIPL
;		IPLROM$2000.wɓǂݍŎs
;		Np[eBV܂͎蓮őIAIꂽp[eBVSASIp[eBVIPL$2400.wɓǂݍŎs
;		AhX
;		$00000000	SASIfBXNIPL
;
;	p[eBVe[u
;		AhX	10MB		20MB		40MB
;		$00000400	$5836384B	$5836384B	$5836384B	X68K}WbN
;		$00000404	$00009F54	$00013C98	$00027930	R[h(fBXNC[W̃TCY)
;				33*4*309=40788	33*4*614=81048	33*8*614=162096
;		$00000408	$00009F54	$00013C98	$00027930	փR[h
;		$0000040C	$0000AF50	$00015660	$0002ACC0	VbsO][
;				33*4*340=44880	33*4*664=87648	33*8*664=175296
;		$00000410	1p[eBV̏
;		$00000410	$48756D61	$48756D61	$48756D61	Huma}WbN
;		$00000414	$6E36386B	$6E36386B	$6E36386B	n68k}WbN
;		$00000418	$00000021	$00000021	$00000021	JnR[h
;		$0000041C	$00009F2E	$00013C68	$000278F8	R[h
;		$00000420	2p[eBV̏
;			:
;		$000004F0	15p[eBV̏
;		$00000500	
;			:
;
;	1p[eBV(10MB̑uɍőTCỸp[eBVmۂꍇ)
;		AhX	ZN^
;		$00002100	$00000000	SASIp[eBVIPL
;							SASIfBXNIPL$2400.wɓǂݍŎs
;							[gfBNgɂHUMAN.SYS$6800.wɓǂݍŎs
;		$00002500	$00000001	1FAT
;		$00007500	$00000015	2FAT
;		$0000C500	$00000029	[gfBNg
;		$00010500	$00000039	f[^̈
;
;	hCu(őTCỸp[eBVmۂꍇ)
;		10MB	20MB	40MB
;		1024	1024	1024	oCg/ZN^
;		1	1	1	ZN^/NX^
;		10132	20155	40335	f[^̈̃NX^+2
;		1	1	1	\̈̃ZN^
;		20	40	80	1FAT̈ɎgpZN^
;		41	81	161	[gfBNg̐擪ZN^ԍ
;		512	512	512	[gfBNgɓGg
;		57	97	177	f[^̈̐擪ZN^ԍ
;

scsi_bios_end:

  .if SCSI_BIOS_LEVEL==0
;P[ge[u
	.dc.w	$0000,$0004,$0004,$0004,$0004,$0004,$0004,$0004
	.dc.w	$0004,$0038,$0004,$0014,$0144,$04C2,$0490,$001A
	.dc.w	$001C,$005E,$0156,$004A,$004A,$004A,$004A,$004C
	.dc.w	$0060,$0064,$0056,$005C,$0016,$003E,$003C,$003C
	.dc.w	$003E,$004C,$004E,$004A,$004A,$04FC,$0012,$0012
	.dc.w	$01AC,$0024,$0010
;V{e[u
	.dc.w	$0201
	.dc.l	install_sasi_iocs
	.dc.b	'sainit',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_4F_B_EJECT
	.dc.b	'b_eject',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_F5_SCSIDRV
	.dc.b	'SCSI',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_00_S_RESET
	.dc.b	'S_RESET',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_01_S_SELECT
	.dc.b	'S_SELECT',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_02_S_SELECTA
	.dc.b	'S_SELECTA',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_03_S_CMDOUT
	.dc.b	'S_CMDOUT',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_04_S_DATAIN
	.dc.b	'S_DATAIN',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_05_S_DATAOUT
	.dc.b	'S_DATAOUT',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_06_S_STSIN
	.dc.b	'S_STSIN',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_07_S_MSGIN
	.dc.b	'S_MSGIN',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_08_S_MSGOUT
	.dc.b	'S_MSGOUT',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_09_S_PHASE
	.dc.b	'S_PHASE',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_0A_S_LEVEL
	.dc.b	'S_LEVEL',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_0B_S_DATAINI
	.dc.b	'S_DATAINI',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_0C_S_DATAOUTI
	.dc.b	'S_DATAOUTI',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_24_S_TESTUNIT
	.dc.b	'testunit',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2B_S_REZEROUNIT
	.dc.b	'rezerounit',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2E_S_READI
	.dc.b	'readi',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_25_S_READCAP
	.dc.b	'readcap',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_20_S_INQUIRY
	.dc.b	'inquiry',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2C_S_REQUEST
	.dc.b	'request',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_21_S_READ
	.dc.b	'read',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_22_S_WRITE
	.dc.b	'write',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_23_S_FORMAT
	.dc.b	'format',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2F_S_STARTSTOP
	.dc.b	'startstop',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_30_S_SEJECT
	.dc.b	'seject',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2D_S_SEEK
	.dc.b	'seek',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_36_S_DSKINI
	.dc.b	'dskini',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_37_S_FORMATB
	.dc.b	'formatb',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_38_S_BADFMT
	.dc.b	'badfmt',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_39_S_ASSIGN
	.dc.b	'assign',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_29_S_MODESENSE
	.dc.b	'modesense',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_2A_S_MODESELECT
	.dc.b	'modeselect',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_31_S_REASSIGN
	.dc.b	'reassign',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_26_S_READEXT
	.dc.b	'readext',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_27_S_WRITEEXT
	.dc.b	'writeext',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_28_S_VERIFYEXT
	.dc.b	'verifyext',$00
	.even
	.dc.w	$0201
	.dc.l	scsi_32_S_PAMEDIUM
	.dc.b	'pamedium',$00
	.even
	.dc.w	$0201
	.dc.l	jump_00_0F
	.dc.b	'cmdtbl1',$00
	.even
	.dc.w	$0201
	.dc.l	jump_20_3F
	.dc.b	'cmdtbl2',$00
	.even
	.dc.w	$0201
	.dc.l	jump_40_4F
	.dc.b	'cmdtbl3',$00
	.even
	.dc.w	$0201
	.dc.l	select_and_cmdout
	.dc.b	'command',$00
	.even
	.dc.w	$0201
	.dc.l	stsin_and_msgin
	.dc.b	'ms_get',$00
	.even
	.dc.w	$0201
	.dc.l	spc_interrupt_routine
	.dc.b	'scsi_int',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_cpu
	.dc.b	'man_out',$00
	.even
	.dc.w	$0201
	.dc.l	dataouti_transfer
	.dc.b	'prg_out',$00
	.even
	.dc.w	$0201
	.dc.l	dataini_transfer
	.dc.b	'prg_in',$00
	.even
	.dc.w	$0201
	.dc.l	datain_cpu
	.dc.b	'man_in',$00
	.even
	.dc.w	$0201
	.dc.l	dataini_wait
	.dc.b	'wt_pin',$00
	.even
	.dc.w	$0201
	.dc.l	dataini_loop
	.dc.b	'st_pin',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_cpu_loop
	.dc.b	'st_mout',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_cpu_wait_1
	.dc.b	'aa_mout',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_cpu_wait_2
	.dc.b	'na_mout',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_cpu_end
	.dc.b	'ed_mout',$00
	.even
	.dc.w	$0201
	.dc.l	datain_cpu_loop
	.dc.b	'st_min',$00
	.even
	.dc.w	$0201
	.dc.l	datain_cpu_wait_1
	.dc.b	'aa_min',$00
	.even
	.dc.w	$0201
	.dc.l	datain_cpu_wait_2
	.dc.b	'na_min',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_wait
	.dc.b	'dout_loop',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_transfer
	.dc.b	'dma_out',$00
	.even
	.dc.w	$0201
	.dc.l	datain_transfer
	.dc.b	'dma_in',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_transfer_end
	.dc.b	'er_dout',$00
	.even
	.dc.w	$0201
	.dc.l	dataout_transfer_no_error
	.dc.b	'ed_dout',$00
	.even
	.dc.w	$0201
	.dc.l	datain_transfer_end
	.dc.b	'er_din',$00
	.even
	.dc.w	$0201
	.dc.l	datain_transfer_wait
	.dc.b	'ew_din',$00
	.even
	.dc.w	$0201
	.dc.l	datain_transfer_no_error
	.dc.b	'ed_din',$00
	.even
	.dc.w	$0203
	.dc.l	scsi_bios_end
	.dc.b	'allend',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_40_B_SEEK
	.dc.b	'b_seek',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_41_B_VERIFY
	.dc.b	'b_verify',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_43_B_DSKINI
	.dc.b	'b_dskini',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_44_B_DRVSNS
	.dc.b	'b_drvsns',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_45_B_WRITE
	.dc.b	'b_write',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_46_B_READ
	.dc.b	'b_read',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_47_B_RECALI
	.dc.b	'b_recali',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_48_B_ASSIGN
	.dc.b	'b_assign',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_4B_B_BADFMT
	.dc.b	'b_badfmt',$00
	.even
	.dc.w	$0201
	.dc.l	iocs_4D_B_FORMAT
	.dc.b	'b_format',$00
	.even
;
    .if SCSIEXROM
	.dcb.b	$2000-$1F18,$FF
    .else
	.dcb.b	$2000-$1EF8,$FF
    .endif
  .elif SCSI_BIOS_LEVEL==3
;
    .if SCSIEXROM
	.dcb.b	$2000-$1B1E,$FF
    .else
	.dcb.b	$2000-$1AFE,$FF
    .endif
  .endif



	.end
